$(document).ready(function () {

    $('body').on('hidden.bs.popover', function (e) {
        $(e.target).data("bs.popover").inState.click = false;
    });

    $('[data-popover-id]').each(function () {
        var element = $(this);

        var relatedElementId = element.data('popover-id');
        var relatedElement = $(relatedElementId);
        var content = element.data('popover-content');

        relatedElement.popover({
            content: content,
            html: true,
            placement: 'bottom'
        });
    });

    $('[data-popover-id]').click(function () {
        var element = $(this);

        var relatedElementId = element.data('popover-id');
        var relatedElement = $(relatedElementId);

        relatedElement.select();
        document.execCommand("copy");

        relatedElement.popover('toggle');
        setTimeout(function () {
            relatedElement.popover('toggle');
        }, 3000);
    });

    $(document).on('click', '#downloadButton', function () {
        location.href = $(this).attr('data-url');
        $('#update-content').css("display", "block");
        $('#download-content').css("display", "none");
    });
});