<%@ Page Language="C#" MasterPageFile="~/Common/MasterPage/MasterPage.master"   
    AutoEventWireup="true" CodeBehind="CustomizationConsole.aspx.cs" Inherits="WebStation.Customization.CustomizationConsole"
    meta:resourcekey="PageResource1" %>

<%@ Register TagPrefix="dbwc" Namespace="DBauer.Web.UI.WebControls" Assembly="DBauer.Web.UI.WebControls.DynamicControlsPlaceholder" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>


<asp:Content ID="CustomizationContent" ContentPlaceHolderID="Main" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
        <Scripts>
            <asp:ScriptReference Path="../Common/JavaScript/Silverlight.js" />
            <asp:ScriptReference Path="../Common/JavaScript/prototype.js" />
        </Scripts>
    </asp:ScriptManager>
   
    <input type="hidden" runat="server" id="ApplyCustomizationChange" />
    <input type="hidden" runat="server" id="SilverlightError" /> 
    <script type="text/javascript">
    //Catch Silverlight Error 
    //and force a post back in order to throw it to asp.net
    function onSilverlightError(sender, args) {

        // There seems to be a problem with the Silverlight plugin and Firefox. By disabling this error check, it works.
        if (Prototype.Browser.Gecko)
            return;

        var appSource = "";
        if (sender != null && sender != 0) {
            appSource = sender.getHost().Source;

        }


        var errorType = args.ErrorType;
        var iErrorCode = args.ErrorCode;

        if (errorType == "ImageError" || errorType == "MediaError") {
            return;
        }

        var errMsg = "Unhandled Error in Silverlight Application " + appSource + "\n";

        errMsg += "Code: " + iErrorCode + "    \n";
        errMsg += "Category: " + errorType + "       \n";
        errMsg += "Message: " + args.ErrorMessage + "     \n";

        if (errorType == "ParserError") {
            errMsg += "File: " + args.xamlFile + "     \n";
            errMsg += "Line: " + args.lineNumber + "     \n";
            errMsg += "Position: " + args.charPosition + "     \n";
        }
        else if (errorType == "RuntimeError") {
            if (args.lineNumber != 0) {
                errMsg += "Line: " + args.lineNumber + "     \n";
                errMsg += "Position: " + args.charPosition + "     \n";
            }
            errMsg += "MethodName: " + args.methodName + "     \n";
        }

        window.document.getElementById('<%=this.SilverlightError.ClientID %>').value = errMsg.escapeHTML();

        __doPostBack('', '');
 
    }
 
    /*SILVERLIGHT METHODS*/
    var silverlightControl = null;

    //event when the silverlight control is loaded
    function onSilverLightLoaded(sender, args) {
        silverlightControl = document.getElementById('silverlightControl');
        ResizeSilverlight();
    }

    function ResizeSilverlight() {
        if (silverlightControl != null)
            silverlightControl.Content.Page.ResizeSilverlightDataGrid(document.getElementById('divCustomizationConsole').offsetHeight);
    }

    function setCustomizationSilverlightSize(val) {
        var host = document.getElementById("silverlightCustomizationHost"); 
        host.style.height = val[0] + "px";
    }

    function applyCustomizationChange() {
        window.document.getElementById('<%=this.ApplyCustomizationChange.ClientID %>').value = "1"; 
        __doPostBack('', '');
    }

 

    </script>


<div id="divCustomizationConsole" style="height:100%;width:100%">
       
    <div id="silverlightCustomizationHost" style="height:100%;width:100%">
        <object id="silverlightControl" width="100%" height="100%" data="data:application/x-silverlight-2,"
            type="application/x-silverlight-2">
            <param name="source" value="../ClientBin/Kantech.Silverlight.Customization.xap" />
            <param name="onError" value="onSilverlightError" />
            <param name="background" value="white" />
            <param name="minRuntimeVersion" value="3.0.50106.0" />
            <param name="onerror" value="onSilverlightError" />
            <param name="onload" value="onSilverLightLoaded" />
            <param name="autoUpgrade" value="true" />
            <param runat="server" name="Windowless" id="WindowlessParam" value="" />

            <%--decrease performance when true--%>
            <param name="EnableGPUAcceleration" value="false" />
            <param runat="server" name="initParams" id="SilverLightInitParams" value="" />
             <a href="http://go.microsoft.com/fwlink/?LinkID=149156&v=3.0.50106.0" style="text-decoration: none">
                    <img src="http://go.microsoft.com/fwlink/?LinkId=161376" alt="Get Microsoft Silverlight"
                        style="border-style: none" />
                </a>
        </object>
    </div>
 </div>
    
</asp:Content>
