﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="TimeRangeSliderUC.ascx.cs"
    Inherits="Kantech.TimeRangeSliderUC" %>
<div class="dualSliderAreaStyle">
    <div id="<%=this.ClientID%>_dualSliderWrapper" class="dualSliderWrapperStyle">
        <span class="intervalTimeStyleStart">00:00</span> <span class="intervalTimeStyle6">06:00</span>
        <span class="intervalTimeStyle12">12:00</span> <span class="intervalTimeStyle18">18:00</span>
        <span class="intervalTimeStyleEnd">24:00</span>
        <div id="<%=this.ClientID%>_dualSliderRailBody" class="dualSliderRailBodyStyle">
            <div id="<%=this.ClientID%>_leftHandle" class="dualSliderHandleStyle">
                <asp:Image runat="server" ID="LeftImage" />
            </div>
            <div id="<%=this.ClientID%>_rightHandle" class="dualSliderHandleStyle">
                <asp:Image runat="server" ID="RightImage" />
            </div>
            <div id="<%=this.ClientID%>_dualSliderSelectedSpan" class="dualSliderSpanStyle">
            </div>
        </div>
        <div class="dualSliderReadoutStyle" id="divdualSliderReadoutSpan" runat="server">
            <span id="<%=this.ClientID%>_dualSliderReadoutSpan"></span>
            <asp:TextBox ID="CurrentStartTime" runat="server" MaxLength="5" CssClass="TextBoxScheduleIntervals" />
            <asp:TextBox ID="CurrentEndTime" runat="server" MaxLength="5" CssClass="TextBoxScheduleIntervals" />
        </div>
    </div>

    <script language="javascript" type="text/javascript" charset="utf-8">
        // <![CDATA[


        var isIE = document.all ? true : false;
        var BrowserVersion = '<%= ((WebStation.Scheduler.Scheduler)this.Page).BrowserVersion%>';
    

        var startDefault = ConvertDateToMinutes(document.getElementById("<%=this.ClientID%>_CurrentStartTime").value);
        var endDefault = ConvertDateToMinutes(document.getElementById("<%=this.ClientID%>_CurrentEndTime").value);

        window['<%=this.ClientID%>_defaultValues'] = [startDefault, endDefault];

        window['<%=this.ClientID%>_dualSliderReadout'] = null;


        document.getElementById("<%=this.ClientID%>_dualSliderReadoutSpan").innerHTML = "";

        var v_alignX = 2;  
        if (isIE) {
            if (BrowserVersion == "IE6")
                var v_alignX = -5; 
            }

        
        
        window['<%=this.ClientID%>_dualSlider'] = new Control.Slider(['<%=this.ClientID%>_leftHandle', '<%=this.ClientID%>_rightHandle'],
                                                     '<%=this.ClientID%>_dualSliderRailBody',
			                                         { sliderValue: window['<%=this.ClientID%>_defaultValues'],
			                                             range: $R(0, 1440),
			                                             restricted: false,
			                                             spans: ['<%=this.ClientID%>_dualSliderSelectedSpan'],
			                                             maximum: 1440,
			                                             minimum: 0,
			                                             increment: 5,
			                                             alignX: v_alignX
			                                         });



        //******************************
        //Function _updateReadout
        //******************************
        window['<%=this.ClientID%>_updateReadout'] = function(v) {


            /* Update the UI with new values */
            if (window['<%=this.ClientID%>_dualSliderReadout'] == null) {
                window['<%=this.ClientID%>_dualSliderReadout'] = document.getElementById("<%=this.ClientID%>_dualSliderReadoutSpan");
            }


            //window['<%=this.ClientID%>_dualSliderReadout'].innerHTML = ConvertToDate(parseInt(v[0]).toFixed(0)) + " to " + ConvertToDate(parseInt(v[1]).toFixed(0));
            document.getElementById("<%=this.ClientID%>_dualSliderSelectedSpan").style.width = document.getElementById("<%=this.ClientID%>_dualSliderSelectedSpan").offsetWidth + 5;
            document.getElementById("<%=this.ClientID%>_CurrentStartTime").value = ConvertToDate(parseInt(v[0]));
            document.getElementById("<%=this.ClientID%>_CurrentEndTime").value = ConvertToDate(parseInt(v[1]));


        }



        function ValidateTime(startTime, endTime) {



            //Format validation
            var reg = /^(20|21|22|23|24|[01]\d|\d)(([:][0-5]\d){1,2})$/;


            if (!reg.test(startTime) || !reg.test(endTime)) {
                return -1;
            }

            var endtime = ConvertDateToMinutes(endTime);

            if (ConvertDateToMinutes(startTime) > endtime || endtime > 1440) {
                return 0;
            }


            return 1;


        }


        //******************************************
        //Méthode qui met à jour la valeur du slider
        //handleIndex==0? start time update, handleIndex==1? end time update, null==both time update
        //******************************************
        window['<%=this.ClientID%>_UpdateSlider'] = function(handleIndex, startTime, endTime) {


            var valueToUpdate;
            var defaultStartTime = startTime;
            var defaultEndTime = endTime;

            //Si l'utilisateur inscrit seulement l'heure, on concatène cette valeur avec :00
            if ((startTime.length == 1 || startTime.length == 2) && startTime.indexOf(':') == -1) {

                if (startTime.length == 1)
                    startTime = "0" + startTime + ":00";
                else
                    startTime = startTime + ":00";

                document.getElementById("<%=this.ClientID%>_CurrentStartTime").value = startTime;
            }

            if ((endTime.length == 1 || endTime.length == 2) && endTime.indexOf(':') == -1) {

                if (endTime.length == 1)
                    endTime = "0" + endTime + ":00";
                else
                    endTime = endTime + ":00";

                document.getElementById("<%=this.ClientID%>_CurrentEndTime").value = endTime;
            }
            //************************************************************************************



            var validationResultCode = ValidateTime(startTime, endTime);


            if (validationResultCode == -1) {
                startTime = defaultStartTime;
                alert('<%=Resources.AppResource.timeInvalidError%>')
                return 0;
            }

            if (validationResultCode == 0) {
                //alert('<%=Resources.AppResource.EndDateMustBeAfterStart%>')
                return 0;
            }

            var startTimeInMinutes = ConvertDateToMinutes(startTime);
            var endTimeInMinutes = ConvertDateToMinutes(endTime);


            window['<%=this.ClientID%>_dualSlider'].setValue(startTimeInMinutes, 0);
            window['<%=this.ClientID%>_dualSlider'].setValue(endTimeInMinutes, 1);
            
//            if (handleIndex == 0)
//                window['<%=this.ClientID%>_dualSlider'].setValue(startTimeInMinutes, 0);
//            else {
//                if (handleIndex == 1)
//                    window['<%=this.ClientID%>_dualSlider'].setValue(endTimeInMinutes, 1);
//                else {
//                    window['<%=this.ClientID%>_dualSlider'].setValue(startTimeInMinutes, 0);
//                    window['<%=this.ClientID%>_dualSlider'].setValue(endTimeInMinutes, 1);
//                }
//            }

            document.getElementById("<%=this.ClientID%>_dualSliderSelectedSpan").style.width = document.getElementById("<%=this.ClientID%>_dualSliderSelectedSpan").offsetWidth + 5;

            return 1;



        }




        //******************************
        //Function ConvertDateToMinutes
        //******************************
        function ConvertDateToMinutes(time) {

            //must convert the time back to the minutes
            if (time == "undefined")
                time = "00:00";

            var separatorIndex = time.indexOf(':');


            var minutes = time.substring(separatorIndex + 1, String(time).length)
            var hours = time.substring(0, 2);

            return (Number(hours) * 60) + Number(minutes);


        }

        //******************************
        //Function ConvertToDate
        //******************************
        function ConvertToDate(totalMinutes) {

            var modulo = totalMinutes % 5;

            if (totalMinutes % 5 > 0) {
                totalMinutes = totalMinutes + (5 - modulo);
            }

            var separator = ":";
            var minutes = totalMinutes % 60;
            var hours = (totalMinutes - minutes) / 60;

            if (String(minutes).length == 1) {
                minutes = "0" + minutes;
            }

            if (String(hours).length == 1) {
                hours = "0" + hours;
            }


            if (String(minutes).length == 1) {
                minutes = "00" + minutes;

            }

            return hours + separator + minutes

        }


        //******************************
        //Function _detectAndUpdate
        //******************************
        window['<%=this.ClientID%>_detectAndUpdate'] = function(v, evt) {

            window['<%=this.ClientID%>_collisionDetect'](v, evt);
            window['<%=this.ClientID%>_updateReadout'](v);

        }







        //******************************
        //Function collisionDetect
        //******************************
        window['<%=this.ClientID%>_collisionDetect'] = function(v, evt) {

            if (parseInt(v[0]) > parseInt(v[1])) {
                if (evt.activeHandleIdx == 0) {
                    v[0] = v[1];
                    window['<%=this.ClientID%>_dualSlider'].setValue(v[0], 0);
                }
                else {
                    v[1] = v[0];
                    window['<%=this.ClientID%>_dualSlider'].setValue(v[1], 1);
                }

            }
            if (parseInt(v[0]) == parseInt(v[1])) {
                if (parseInt(v[1]) == 1440 || evt.activeHandleIdx == 0) {
                    document.getElementById("<%=this.ClientID%>_leftHandle").style.zIndex = 99999;
                    document.getElementById("<%=this.ClientID%>_rightHandle").style.zIndex = 88888;
                }
            }
            else {
                document.getElementById('<%=this.ClientID%>_leftHandle').style.zIndex = 88888;
                document.getElementById('<%=this.ClientID%>_rightHandle').style.zIndex = 99999;
            }

            lowerL = parseInt(v[0]);
            lowerR = parseInt(v[0]) + window['<%=this.ClientID%>_handleLeftWidth'];

            // Get right handle offsets
            upperL = parseInt(v[1]) - window['<%=this.ClientID%>_handleLeftWidth'];
            upperR = parseInt(v[1]);


            // First handle
            if ((evt.activeHandleIdx == 0) && (lowerL >= upperL)) {

                // Remove the change event to prevent infinite recursion
                window['<%=this.ClientID%>_dualSlider'].options.onChange = null;

                // Set the new slider value
                window['<%=this.ClientID%>_dualSlider'].setValue(upperL, 0);
            }


            // Second handle
            if ((evt.activeHandleIdx == 1) && (upperR <= lowerR)) {
                // Remove the change event to prevent infinite recursion
                window['<%=this.ClientID%>_dualSlider'].options.onChange = null;
                // Set the new slider value
                window['<%=this.ClientID%>_dualSlider'].setValue(lowerR, 1);
            }
        }




        //******************************
        //Function onSlide
        //******************************
        window['<%=this.ClientID%>_dualSlider'].options.onSlide = function(v, evt) {


            window['<%=this.ClientID%>_detectAndUpdate'](v, evt);
            SetDirty();
        }



 
    </script>

</div>
