<%@ Page Language="C#" MasterPageFile="~/Common/MasterPage/MasterPage.master"
    AutoEventWireup="true" CodeBehind="Scheduler_old.aspx.cs" Inherits="WebStation.Scheduler.Scheduler"
    meta:resourcekey="PageResource1" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register Src="TimeRangeSliderUC.ascx" TagName="TimeRangeSliderUC" TagPrefix="slider" %>
<asp:Content ID="SchedulerContent" ContentPlaceHolderID="MainOutsideSplitter" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">


        <Scripts>
            <asp:ScriptReference Path="TimeRangeSlider/Js/prototype.js" />
            <asp:ScriptReference Path="TimeRangeSlider/Js/slider.js" />
            <asp:ScriptReference Path="../Common/JavaScript/tooltip/wz_tooltip.js" />
        
        </Scripts>
        
    </asp:ScriptManager>
 
    
    <div id="divScheduler">
        <input type="hidden" runat="server" id="MustRefreshControls" />
        <input type="hidden" runat="server" id="MustSaveAs" />
        <input type="hidden" runat="server" id="MustAddNew" />
        <input type="hidden" runat="server" id="SelectedRowID" />
        <input type="hidden" runat="server" id="hfIsDirty" enableviewstate="true" />
        <input type="hidden" runat="server" id="MustCheckCellInfos" enableviewstate="true" />
        <link href="Scheduler/TimeRangeSlider/DualSlider.css" rel="stylesheet" type="text/css" />
        
        <asp:UpdatePanel ID="upGateway" runat="server" RenderMode="Inline">
            <ContentTemplate>
                <div id="messagePanelSaveAs">
                    <asp:Button runat="server" ID="targetControlSaveAs" Style="display: none" meta:resourcekey="targetControlSaveAsResource1" />
                    <ajaxToolkit:ConfirmButtonExtender ID="ConfirmButtonExtenderSaveAs" runat="server"
                        TargetControlID="targetControlSaveAs" DisplayModalPopupID="ModalPopupExtenderSaveAs"
                        ConfirmText="" Enabled="True" />
                    <br />
                    <ajaxToolkit:ModalPopupExtender ID="ModalPopupExtenderSaveAs" runat="server" TargetControlID="targetControlSaveAs"
                        PopupControlID="PNL" OkControlID="btnSaveAs_OK" CancelControlID="btnSaveAs_Cancel"
                        BackgroundCssClass="modalBackground" DynamicServicePath="" Enabled="True">
                    </ajaxToolkit:ModalPopupExtender>
                    <asp:Panel ID="PNL" runat="server" Style="display: none; padding: 20px" CssClass="modalMessage"
                        meta:resourcekey="PNLResource1">
                        <div style="text-align: left;">
                            <asp:Label ID="lblNewSchedulelName" runat="server" Text="<%$ Resources:AppResource,  messScheduleSaveAs %>"
                                meta:resourcekey="lblNewSchedulelNameResource1"></asp:Label><br />
                            <br />
                            <asp:Label ID="lblSaveAsPrimaryLanguage" runat="server"   Width="80px"
                              ></asp:Label><asp:TextBox ID="txtSaveAsPrimaryLanguage"
                                    runat="server" TabIndex="2" CssClass="SaveAsDesc" Width="200px" MaxLength="40"
                                    meta:resourcekey="txtSaveAsPrimaryLanguageResource1"></asp:TextBox><br />
                            <asp:Label ID="lblSaveAsSecondaryLanguage" runat="server" Width="80px"
                                meta:resourcekey="lblSaveAsSecondaryLanguageResource1"></asp:Label><asp:TextBox ID="txtSaveAsSecondaryLanguage"
                                    runat="server" TabIndex="3" CssClass="SaveAsDesc" Width="200px" MaxLength="40"
                                   ></asp:TextBox>
                        </div>
                        <br />
                        <div style="text-align: center;">
                            <asp:Button ID="btnSaveAs_OK" Width="75px" Height="23px" runat="server" Text="<%$ Resources:AppResource, btnOK %>"
                                OnClientClick="SaveAs();" meta:resourcekey="btnSaveAs_OKResource1" />
                            <asp:Button ID="btnSaveAs_Cancel" Width="75px" Height="23px" runat="server" Text="<%$ Resources:AppResource, btnCancel %>"
                                meta:resourcekey="btnSaveAs_CancelResource1" />
                        </div>
                    </asp:Panel>
                </div>
                <div id="divMessageOperationFeedBack">
                    <asp:Button runat="server" ID="TargetControlForMessageOperationFeedBack" Style="display: none"
                        meta:resourcekey="TargetControlForMessageOperationFeedBackResource1" />
                    <ajaxToolkit:ModalPopupExtender runat="server" ID="ModalPopupMessageOperationFeedBack"
                        BehaviorID="ModalPopupBehaviorMessageOperationFeedBack" TargetControlID="TargetControlForMessageOperationFeedBack"
                        PopupControlID="PanelMessageOperationFeedBack" BackgroundCssClass="modalBackground"
                        CancelControlID="btnOk" DynamicServicePath="" Enabled="True">
                    </ajaxToolkit:ModalPopupExtender>
                    <asp:Panel ID="PanelMessageOperationFeedBack" runat="server" Style="display: none;
                        padding: 20px" CssClass="modalMessage" meta:resourcekey="PanelMessageOperationFeedBackResource1">
                        <div>
                            <asp:Label runat="server" ID="lblMessageOperationFeedBack" Text="<%$ Resources:AppResource, SchedulelblMessageOperationFeedBack %>" meta:resourcekey="lblMessageOperationFeedBackResource1"></asp:Label><br />
                            <br />
                        </div>
                        <div style="text-align: center;">
                            <asp:Button ID="btnOk" Width="75px" Height="23px" runat="server" Text="<%$ Resources:AppResource, btnOK %>"
                                meta:resourcekey="btnOkResource1" />
                        </div>
                    </asp:Panel>
                </div>

                <div id="MessageError">
                    <asp:Button runat="server" ID="btnMessageError" Style="display: none" meta:resourcekey="btnMessageErrorResource1" />
                    <ajaxToolkit:ModalPopupExtender runat="server" ID="ModalPopupExtenderMessageError"
                        BehaviorID="ModalPopupBehaviorMessageError" TargetControlID="btnMessageError"
                        PopupControlID="PanelMessageError" BackgroundCssClass="modalBackground" DynamicServicePath=""
                        Enabled="True">
                    </ajaxToolkit:ModalPopupExtender>
                    <asp:Panel ID="PanelMessageError" runat="server" Style="display: none; padding: 20px"
                        CssClass="modalMessage" meta:resourcekey="PanelMessageErrorResource1">
                        <div>
                            <asp:Label runat="server" ID="lblMessageError" meta:resourcekey="lblMessageErrorResource1"></asp:Label><br />
                            <br />
                        </div>
                        <div style="text-align: center;">
                            <asp:Button ID="btnOKMessageError" Width="75px" Height="23px" runat="server" Text="<%$ Resources:AppResource, btnOK %>"
                                OnClientClick="checkForReloadPage(); " OnClick="btnOKMessageError_Click" meta:resourcekey="btnOKMessageErrorResource1" />
                        </div>
                    </asp:Panel>
                </div>
                <div id="divMessageConfirmation">
                    <asp:HiddenField runat="server" ID="MessageConfirmationActionValue" />
                    <asp:Button runat="server" ID="TargetControlForMessageConfirmation" Style="display: none"
                        meta:resourcekey="TargetControlForMessageConfirmationResource1" />
                    <ajaxToolkit:ModalPopupExtender runat="server" ID="ModalPopupConfirmation" BehaviorID="ModalPopupBehaviorMessageOK"
                        TargetControlID="TargetControlForMessageConfirmation" PopupControlID="PanelMessageConfirmation"
                        BackgroundCssClass="modalBackground" CancelControlID="ButtonCancel" DynamicServicePath=""
                        Enabled="True">
                    </ajaxToolkit:ModalPopupExtender>
                    <asp:Panel ID="PanelMessageConfirmation" runat="server" Style="display: none; padding: 20px"
                        CssClass="modalMessage" meta:resourcekey="PanelMessageConfirmationResource1">
                        <asp:Label ID="lblMessageConfirmation" runat="server"></asp:Label>
                        <asp:TextBox ID="txtPKDATA" Style="display: none" runat="server" meta:resourcekey="txtPKDATAResource1"></asp:TextBox>
                        <br />
                        <br />
                        <div style="text-align: center;">
                            <asp:Button ID="ButtonOk" Width="75px" Height="23px" runat="server" Text="<%$ Resources:AppResource, btnOK %>"
                                OnClick="btnConfirmationOK_Click" meta:resourcekey="ButtonOkResource1" />
                            <asp:Button ID="ButtonCancel" Width="75px" Height="23px" runat="server" Text="<%$ Resources:AppResource, btnCancel %>"
                                meta:resourcekey="ButtonCancelResource1" />
                        </div>
                    </asp:Panel>
                </div>
                <table id="tabSchedule" style="width: 100%;">
                    <tr>
                        <th align="left" style="width: 37%;">
                            <asp:Label ID="lblGateway" runat="server" style="padding-bottom:3px"  Width="110px" Text="<%$ Resources:AppResource, SchedulelblGateway %>" meta:resourcekey="lblGatewayResource1">Gateway/Site:</asp:Label>
                            
                             
                            <asp:DropDownList ID="ddlGateway" runat="server"   AutoPostBack="True"
                               OnSelectedIndexChanged="ddlGateway_SelectedIndexChanged" Width="200px" CssClass="DropdownListSchedule"
                                meta:resourcekey="ddlGatewayResource1"  TabIndex="1">
                            </asp:DropDownList>
 
                        </th>
                        <th align="left" style="width: 63%;">
                            <asp:Label ID="lblLanguage1Label" runat="server" CssClass="labelFields" Width="180px"
                                style="padding-bottom:1px"  > </asp:Label>
                            <asp:TextBox ID="txtLanguage1" runat="server"  TabIndex="3" OnChange="javascript:SetDirty();"
                                MaxLength="40" CssClass="TextBoxSchedule" meta:resourcekey="txtLanguage1Resource1"></asp:TextBox>
                        </th>
                    </tr>
                    <tr>
                        <th align="left">
                            <asp:Label ID="lblScheduleList" runat="server" Width="110px"  style="padding-bottom:3px"  CssClass="labelFields"
                                meta:resourcekey="lblScheduleListResource1" Text="<%$ Resources:AppResource, SchedulelblScheduleList %>">Schedule:</asp:Label>
                            <asp:DropDownList ID="ddlSchedules" runat="server"   Width="200px"  AutoPostBack="True"
                                OnSelectedIndexChanged="ddlSchedules_SelectedIndexChanged" CssClass="DropdownListSchedule"
                                meta:resourcekey="ddlSchedulesResource1" TabIndex="2">
                            </asp:DropDownList>
                             <img id="imgReadOnly" runat="server" src="../Common/Images/readOnly.gif" 
                                    style="vertical-align:bottom"></img>
                        </th>
                        <th align="left">
                            <asp:Label ID="lblLanguage2Label" CssClass="labelFields" style="padding-bottom:1px"  runat="server" Width="180px"
                                 >French Schedule Name:</asp:Label>
                            <asp:TextBox ID="txtLanguage2" runat="server"  OnChange="javascript:SetDirty();"
                                MaxLength="40" CssClass="TextBoxSchedule" meta:resourcekey="txtLanguage2Resource1"
                                TabIndex="4"></asp:TextBox>
                        </th>
                    </tr>
                    <tr>
                        <th align="left">
                            <asp:CheckBox ID="chkExtendedSchedule" runat="server" 
                                Text="<%$ Resources:AppResource, ExtendedScheduleLabel %>" 
                                oncheckedchanged="chkExtendedSchedule_CheckedChanged" 
                                AutoPostBack="True" />
                        </th>
                        <td align="left">
                            &nbsp;
                        </td>
                    </tr>
                </table>
            </ContentTemplate>
            <Triggers>
                <asp:AsyncPostBackTrigger ControlID="ddlGateway" />
                <asp:AsyncPostBackTrigger ControlID="ddlSchedules" />
                <asp:AsyncPostBackTrigger ControlID="txtLanguage1" />
                <asp:AsyncPostBackTrigger ControlID="txtLanguage2" />
            </Triggers>
        </asp:UpdatePanel>
        <div id="divGridAndInterval" runat="server" class="divGridAndInterval">
            <asp:UpdatePanel ID='upGridView' runat="server" RenderMode="Inline">
                <ContentTemplate>
                    <asp:GridView ID="gvSchedule" runat="server" CssClass="GridViewSchedule" AutoGenerateColumns="False"
                        PageSize="4" AllowSorting="True" PageIndex="1" OnRowCreated="gvSchedule_RowCreated"
                        meta:resourcekey="gvScheduleResource1">
                        <EditRowStyle CssClass="GridViewRow" HorizontalAlign="Center" />
                        <HeaderStyle CssClass="GridViewScheduleHeader" />
                        <RowStyle CssClass="GridViewRow" />
                        <AlternatingRowStyle CssClass="GridViewAlterRow" />
                        <Columns>
                            <asp:TemplateField Visible="False" meta:resourcekey="TemplateFieldResource1">
                                <ItemTemplate>
                                </ItemTemplate>
                                <HeaderTemplate>
                                    <asp:Label ID="lblTimeInterval" runat="server" meta:resourcekey="lblTimeIntervalResource1" Text="<%$ Resources:AppResource,  SchedulelblTimeInterval %>">Time Intervals</asp:Label>
                                </HeaderTemplate>
                                <ItemStyle Width="310px" />
                            </asp:TemplateField>
                            <asp:TemplateField meta:resourcekey="TemplateFieldResource2">
                                <ItemTemplate>
                                    <asp:UpdatePanel ID="upContextMenu" UpdateMode="Conditional" runat="server" ChildrenAsTriggers="False"
                                        RenderMode="Inline">
                                        <ContentTemplate>
                                            <asp:HiddenField ID="HiddenField2" runat="server" />
                                            <asp:ImageButton ID="imgPlusButton" ToolTip="<%$ Resources:AppResource,  ScheduleimgPlusButton %>" CommandName="contextMenuAction"
                                                ImageUrl="~/Common/Images/Scheduler/ContextMenu.gif" runat="server" meta:resourcekey="imgPlusButtonResource1" />
                                        </ContentTemplate>
                                        <Triggers>
                                            <asp:AsyncPostBackTrigger ControlID="lnkBtnCloseMenu" EventName="Click" />
                                            <asp:AsyncPostBackTrigger ControlID="lnkApplyToAll" EventName="Click" />
                                            <asp:AsyncPostBackTrigger ControlID="lnkApplyToAllExceptHolidays" EventName="Click" />
                                            <asp:AsyncPostBackTrigger ControlID="lnkApplyToAllWeekDays" EventName="Click" />
                                            <asp:AsyncPostBackTrigger ControlID="lnkRemoveAllDays" EventName="Click" />
                                        </Triggers>
                                    </asp:UpdatePanel>
                                </ItemTemplate>
                                <ItemStyle Width="20px" />
                            </asp:TemplateField>
                            <asp:TemplateField meta:resourcekey="TemplateFieldResource3">
                                <ItemTemplate>
                                    <div runat="server" class="divDayCheck">
                                        <asp:ImageButton CssClass="dayCheckBox" OnClientClick="return false;" ID="imgIntervalSunday"
                                            runat="server"   ImageUrl='<%# GetImgUrl(Eval("sunday")) %>' meta:resourcekey="imgIntervalSundayResource1" />
                                        <asp:CheckBox  runat="server" ID="chkIntervalSunday" Checked='<%# Eval("sunday") %>'
                                            meta:resourcekey="chkIntervalSundayResource1" Style="display: none"/>                                          
                                    </div>
                                </ItemTemplate>
                                <HeaderTemplate>
                                    <asp:Label ID="lblDaysHeaderSunday"  Text="<%$ Resources:AppResource,  SchedulelblDaysHeaderSunday%>" runat="server" meta:resourcekey="lblDaysHeaderSundayResource1">Sun</asp:Label>
                                </HeaderTemplate>
                                <ItemStyle Height="80px" Width="40px" />
                            </asp:TemplateField>
                            <asp:TemplateField meta:resourcekey="TemplateFieldResource4">
                                <ItemTemplate>
                                    <div runat="server" class="divDayCheck">
                                        <asp:ImageButton ID="imgIntervalMonday" CssClass="dayCheckBox" OnClientClick="return false;"
                                            runat="server"  ImageUrl='<%# GetImgUrl(Eval("monday")) %>' meta:resourcekey="imgIntervalMondayResource1" />
                                        <asp:CheckBox  runat="server" ID="chkIntervalMonday" Checked='<%# Eval("monday") %>'
                                            meta:resourcekey="chkIntervalMondayResource1" Style="display: none"/>
                                    </div>
                                </ItemTemplate>
                                <ItemStyle Height="80px" Width="40px" />
                                <HeaderTemplate>
                                    <asp:Label ID="lblDaysHeaderMonday" runat="server"  Text="<%$ Resources:AppResource,  SchedulelblDaysHeaderMonday%>"  meta:resourcekey="lblDaysHeaderMondayResource1">Mon</asp:Label>
                                </HeaderTemplate>
                                <ItemStyle Height="80px" Width="40px" />
                            </asp:TemplateField>
                            <asp:TemplateField meta:resourcekey="TemplateFieldResource5">
                                <ItemTemplate>
                                    <div runat="server" class="divDayCheck">
                                        <asp:ImageButton ID="imgIntervalTuesday" CssClass="dayCheckBox" OnClientClick="return false;"
                                            runat="server"  ImageUrl='<%# GetImgUrl(Eval("tuesday")) %>' meta:resourcekey="imgIntervalTuesdayResource1" />
                                        <asp:CheckBox  runat="server" ID="chkIntervaltuesday" Checked='<%# Eval("tuesday") %>'
                                            meta:resourcekey="chkIntervaltuesdayResource1" Style="display: none"/>
                                    </div>
                                </ItemTemplate>
                                <HeaderTemplate>
                                    <asp:Label ID="lblDaysHeaderTuesday" runat="server"  Text="<%$ Resources:AppResource,  SchedulelblDaysHeaderTuesday%>"  meta:resourcekey="lblDaysHeaderTuesdayResource1">Tue</asp:Label>
                                </HeaderTemplate>
                                <ItemStyle Height="80px" Width="40px" />
                            </asp:TemplateField>
                            <asp:TemplateField meta:resourcekey="TemplateFieldResource6">
                                <ItemTemplate>
                                    <div runat="server" class="divDayCheck">
                                        <asp:ImageButton ID="imgIntervalWednesday" OnClientClick="return false;" CssClass="dayCheckBox"
                                            runat="server" ImageUrl='<%# GetImgUrl(Eval("Wednesday")) %>' meta:resourcekey="imgIntervalWednesdayResource1" />
                                        <asp:CheckBox  runat="server" ID="chkIntervalwednesday" Checked='<%# Eval("Wednesday") %>'
                                            meta:resourcekey="chkIntervalwednesdayResource1" Style="display: none"/>
                                    </div>
                                </ItemTemplate>
                                <HeaderTemplate>
                                    <asp:Label ID="lblDaysHeaderWednesday" runat="server" Text="<%$ Resources:AppResource,  SchedulelblDaysHeaderWednesday%>" meta:resourcekey="lblDaysHeaderWednesdayResource1">Wed</asp:Label>
                                </HeaderTemplate>
                                <ItemStyle Height="80px" Width="40px" />
                            </asp:TemplateField>
                            <asp:TemplateField meta:resourcekey="TemplateFieldResource7">
                                <ItemTemplate>
                                    <div runat="server" class="divDayCheck">
                                        <asp:ImageButton ID="imgIntervalThursday" CssClass="dayCheckBox" OnClientClick="return false;"
                                            runat="server"  ImageUrl='<%# GetImgUrl(Eval("thursday")) %>' meta:resourcekey="imgIntervalThursdayResource1" />
                                        <asp:CheckBox runat="server" ID="chkIntervalthursday" Checked='<%# Eval("thursday") %>'
                                            meta:resourcekey="chkIntervalthursdayResource1"  Style="display: none"/>
                                    </div>
                                </ItemTemplate>
                                <HeaderTemplate>
                                    <asp:Label ID="lblDaysHeaderThursday" runat="server" Text="<%$ Resources:AppResource,  SchedulelblDaysHeaderThursday%>" meta:resourcekey="lblDaysHeaderThursdayResource1">Thu</asp:Label>
                                </HeaderTemplate>
                                <ItemStyle Height="80px" Width="40px" />
                            </asp:TemplateField>
                            <asp:TemplateField meta:resourcekey="TemplateFieldResource8">
                                <ItemTemplate>
                                    <div runat="server" class="divDayCheck">
                                        <asp:ImageButton ID="imgIntervalFriday" CssClass="dayCheckBox" OnClientClick="return false;"
                                            runat="server"  ImageUrl='<%# GetImgUrl(Eval("friday")) %>' meta:resourcekey="imgIntervalFridayResource1" />
                                        <asp:CheckBox  runat="server" ID="chkIntervalfriday" Checked='<%# Eval("friday") %>'
                                            meta:resourcekey="chkIntervalfridayResource1" Style="display: none"/>
                                    </div>
                                </ItemTemplate>
                                <HeaderTemplate>
                                    <asp:Label ID="lblDaysHeaderFriday" runat="server" meta:resourcekey="lblDaysHeaderFridayResource1" Text="<%$ Resources:AppResource,  SchedulelblDaysHeaderFriday %>">Fri</asp:Label>
                                </HeaderTemplate>
                                <ItemStyle Height="80px" Width="40px" />
                            </asp:TemplateField>
                            <asp:TemplateField meta:resourcekey="TemplateFieldResource9">
                                <ItemTemplate>
                                    <div runat="server" class="divDayCheck">
                                        <asp:ImageButton ID="imgIntervalSaturday" CssClass="dayCheckBox" OnClientClick="return false;"
                                            runat="server"  ImageUrl='<%# GetImgUrl(Eval("saturday")) %>' meta:resourcekey="imgIntervalSaturdayResource1" />
                                        <asp:CheckBox  runat="server" ID="chkIntervalSaturday" Checked='<%# Eval("saturday") %>'
                                            meta:resourcekey="chkIntervalSaturdayResource1" Style="display: none"/>
                                    </div>
                                </ItemTemplate>
                                <HeaderTemplate>
                                    <asp:Label ID="lblDaysHeaderSaturday" runat="server" meta:resourcekey="lblDaysHeaderSaturdayResource1" 
                                    Text="<%$ Resources:AppResource,  SchedulelblDaysHeaderSaturday %>">Sat</asp:Label>
                                </HeaderTemplate>
                                <ItemStyle Height="80px" Width="40px" />
                            </asp:TemplateField>
                            <asp:TemplateField meta:resourcekey="TemplateFieldResource10">
                                <ItemTemplate>
                                    <div runat="server" class="divDayCheck">
                                        <asp:ImageButton ID="imgIntervalHol1" CssClass="dayCheckBox" OnClientClick="return false;"
                                            runat="server"  ImageUrl='<%# GetImgUrl(Eval("holiday1")) %>' meta:resourcekey="imgIntervalHol1Resource1"/>
                                        <asp:CheckBox  runat="server" ID="chkIntervalHol1" Checked='<%# Eval("holiday1") %>'
                                            meta:resourcekey="chkIntervalHol1Resource1" Style="display: none"/>
                                    </div>
                                </ItemTemplate>
                                <HeaderTemplate>
                                    <div class="HolidayHeader" id="divHolidayHeader1" runat="server">
                                       <%-- <asp:Image runat="server" ID="imgHol1" ImageUrl="~/Common/Images/Scheduler/Calendar.gif"
                                            ImageAlign="Middle" meta:resourcekey="imgHol1Resource1" class="calendarImage"  />--%>
                                        <asp:Label ID="lblDaysHeaderHol1" runat="server" Text="<%$ Resources:AppResource,  SchedulelblDaysHeaderHol1%>"  meta:resourcekey="lblDaysHeaderHol1Resource1"
                                            Font-Underline="true"></asp:Label>
                                    </div>
                                </HeaderTemplate>
                                <ItemStyle Height="80px" Width="40px" />
                            </asp:TemplateField>
                            <asp:TemplateField meta:resourcekey="TemplateFieldResource11">
                                <ItemTemplate>
                                    <div runat="server" class="divDayCheck">
                                        <asp:ImageButton ID="imgIntervalHol2" CssClass="dayCheckBox" OnClientClick="return false;"
                                            runat="server"  ImageUrl='<%# GetImgUrl(Eval("holiday2")) %>' meta:resourcekey="imgIntervalHol2Resource1" />
                                        <asp:CheckBox  runat="server" ID="chkIntervalHol2" Checked='<%# Eval("holiday2") %>'
                                            meta:resourcekey="chkIntervalHol2Resource1" Style="display: none"/>
                                    </div>
                                </ItemTemplate>
                                <HeaderTemplate>
                                    <div class="HolidayHeader" id="divHolidayHeader2" runat="server">
                                        <%--<asp:Image runat="server" ID="imgHol2" class="calendarImage"  ImageAlign="Middle"
                                            ImageUrl="~/Common/Images/Scheduler/Calendar.gif" meta:resourcekey="imgHol2Resource1" />--%>
                                        <asp:Label ID="lblDaysHeaderHol2" runat="server" Text="<%$ Resources:AppResource,  SchedulelblDaysHeaderHol2%>"  meta:resourcekey="lblDaysHeaderHol2Resource1"
                                            Font-Underline="true"></asp:Label>
                                    </div>
                                </HeaderTemplate>
                                <ItemStyle Height="80px" Width="40px" />
                            </asp:TemplateField>
                            <asp:TemplateField meta:resourcekey="TemplateFieldResource12">
                                <ItemTemplate>
                                    <div runat="server" class="divDayCheck">
                                        <asp:ImageButton ID="imgIntervalHol3" CssClass="dayCheckBox" OnClientClick="return false;"
                                            runat="server"  ImageUrl='<%# GetImgUrl(Eval("holiday3")) %>' meta:resourcekey="imgIntervalHol3Resource1" />
                                        <asp:CheckBox  runat="server" ID="chkIntervalHol3" Checked='<%# Eval("holiday3") %>'
                                            meta:resourcekey="chkIntervalHol3Resource1" Style="display: none"/>
                                    </div>
                                </ItemTemplate>
                                <HeaderTemplate>
                                    <div class="HolidayHeader" id="divHolidayHeader3" runat="server">
                                     <%--   <asp:Image runat="server" ID="imgHol3" class="calendarImage"   ImageAlign="Middle"
                                            ImageUrl="~/Common/Images/Scheduler/Calendar.gif" meta:resourcekey="imgHol3Resource1" />--%>
                                        <asp:Label ID="lblDaysHeaderHol3" runat="server" Text="<%$ Resources:AppResource,  SchedulelblDaysHeaderHol3%>" meta:resourcekey="lblDaysHeaderHol3Resource1"
                                            Font-Underline="true"></asp:Label>
                                    </div>
                                </HeaderTemplate>
                                <ItemStyle Height="80px" Width="40px" />
                            </asp:TemplateField>
                            <asp:TemplateField meta:resourcekey="TemplateFieldResource13">
                                <ItemTemplate>
                                    <div runat="server" class="divDayCheck">
                                       <asp:ImageButton ID="imgIntervalHol4" CssClass="dayCheckBox" OnClientClick="return false;"
                                            runat="server"  ImageUrl='<%# GetImgUrl(Eval("holiday4")) %>' meta:resourcekey="imgIntervalHol4Resource1" />
                                        <asp:CheckBox  runat="server" ID="chkIntervalHol4" Checked='<%# Eval("holiday4") %>'
                                            meta:resourcekey="chkIntervalHol4Resource1" Style="display: none"/>
                                    </div>
                                </ItemTemplate>
                                <HeaderTemplate>
                                    <div class="HolidayHeader" id="divHolidayHeader4" runat="server">
                                      <%--  <asp:Image runat="server" ID="imgHol4" class="calendarImage"  ImageAlign="Middle"
                                            ImageUrl="~/Common/Images/Scheduler/Calendar.gif" meta:resourcekey="imgHol4Resource1" />--%>
                                        <asp:Label ID="lblDaysHeaderHol4" runat="server" Text="<%$ Resources:AppResource,  SchedulelblDaysHeaderHol4%>" meta:resourcekey="lblDaysHeaderHol4Resource1"
                                            Font-Underline="true"></asp:Label>
                                    </div>
                                </HeaderTemplate>
                                <ItemStyle Height="80px" Width="40px" />
                            </asp:TemplateField>
                        </Columns>
                        <SelectedRowStyle BackColor="Silver" BorderColor="#404040" />
                    </asp:GridView>
                </ContentTemplate>
            </asp:UpdatePanel>
            <div id="divSliderHeader">
                <asp:Label runat="server" ID="lblIntervalHeader" CssClass="lblIntervalHeaderstyle"
                    Text="<%$ Resources:AppResource,  SchedulelblIntervalHeader%>" meta:resourcekey="lblIntervalHeaderResource1"></asp:Label>
            </div>
            
            <div id="divSliderInterval1">
                <slider:TimeRangeSliderUC ID="sliderInterval1" runat="server" />
            </div>
            <hr class="Interval1Separator" />
            
            <div id="divSliderInterval2">
                <slider:TimeRangeSliderUC ID="sliderInterval2" runat="server" />
            </div>
            <hr class="Interval2Separator" />
            
            <div id="divSliderInterval3">
                <slider:TimeRangeSliderUC ID="sliderInterval3" runat="server" />
            </div>
            <hr class="Interval3Separator" />
            
            <div id="divSliderInterval4">
                <slider:TimeRangeSliderUC ID="sliderInterval4" runat="server" />
            </div>
            <hr class="Interval4Separator" />
        </div>
        <asp:UpdatePanel runat="server" ID="upButtons" RenderMode="Inline">
            <ContentTemplate>
                <div runat="server" id="divButtons" class="divButtons">
                    <table  id="tblButtons">
                        <tr align="left">
                            <td align="left">
                                <asp:Button ID="btnSave" TabIndex="30" runat="server" OnClick="btnSaveSchedule_Click"
                                    Text="<%$ Resources:AppResource,  SchedulebtnSave %>"  meta:resourcekey="btnSaveResource1" />
                            </td>
                            <td>
                                <asp:Button ID="btnSaveAs" TabIndex="31" runat="server" CssClass="Operationbutton"   Text="<%$ Resources:AppResource,  SchedulebtnSaveAs %>"  OnClick="btnSaveAs_Click"
                                    meta:resourcekey="btnSaveAsResource1" />
                            </td>
                            <td>
                                <asp:Button ID="btnCancel" TabIndex="32" runat="server" CssClass="Operationbutton"  Text="<%$ Resources:AppResource,  SchedulebtnCancel %>" OnClick="btnCancel_Click"
                                    OnClientClick="SetConfirmationActionValue('CANCEL')" meta:resourcekey="btnCancelResource1" />
                            </td>
                            <td>
                                <asp:Button ID="btnDelete" TabIndex="33" runat="server" CssClass="Operationbutton"   OnClick="btnDelete_Click"
                                    OnClientClick="SetConfirmationActionValue('DELETE')" Text="<%$ Resources:AppResource,  SchedulebtnDelete %>" meta:resourcekey="btnDeleteResource1" />
                            </td>
                            <td>
                            <asp:Button ID="btnAddSchedule" CssClass="Operationbutton" TabIndex="34" runat="server" OnClientClick="javascript:AddNewRecord();"                            
                                    Text="<%$ Resources:AppResource,  SchedulebtnAddAccessLevel %>" meta:resourcekey="btnAddAccessLevelResource1" />
<%--                                <div id="divAddSchedule" runat="server" onclick="javascript:AddNewRecord();" onmouseover="this.style.cursor = 'pointer '"
                                    onmouseout="this.style.cursor = 'default'">
                                    <asp:Label ID="lblAddAction" runat="server" CssClass="lblAction" Text="Add Schedule"
                                        meta:resourcekey="lblAddActionResource1"></asp:Label>
                                    <img id="imgAdd" runat="server" src="../Common/Images/BTN/AddRecord.gif" />
                                </div>--%>
                            </td>
                        </tr>
                    </table>
                </div>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>

    <div id="messagePanel">
        <asp:Panel ID="PanelMenuOperation" runat="server" >
            <div id="menuOperation" onmouseout="doHide = 'true';">
                <ul id="navmenu-v">
                    <li>
                        <asp:LinkButton ID="lnkBtnCloseMenu"  Text="<%$ Resources:AppResource,  SchedulelnkBtnCloseMenu %>" runat="server" CssClass="CloseMenuAndReload();" Style="color: Black;
                            background: url(../Common/Images/CloseMenu.jpg);" OnClientClick="CloseMenu();" meta:resourcekey="lnkBtnCloseMenuResource1">Close Menu</asp:LinkButton></li>
                    <li>
                        <asp:LinkButton ID="lnkApplyToAll" Text="<%$ Resources:AppResource,  SchedulelnkApplyToAll %>" runat="server" OnClientClick="ApplyToAllDays();CloseMenuAndReload();"
                            meta:resourcekey="lnkApplyToAllResource1">Apply to all days</asp:LinkButton></li>
                    <li>
                        <asp:LinkButton ID="lnkApplyToAllExceptHolidays" Text="<%$ Resources:AppResource,  SchedulelnkApplyToAllExceptHolidays %>" runat="server" OnClientClick="ApplyToAllDaysExceptHolidays();CloseMenuAndReload();"
                            meta:resourcekey="lnkApplyToAllExceptHolidaysResource1">Apply to all days except holidays</asp:LinkButton></li>
                    <li>
                        <asp:LinkButton ID="lnkApplyToAllWeekDays" Text="<%$ Resources:AppResource,  SchedulelnkApplyToAllWeekDays %>" runat="server" OnClientClick="ApplyToAllWeekdays();CloseMenuAndReload();"
                            meta:resourcekey="lnkApplyToAllWeekDaysResource1">Apply to all weekdays</asp:LinkButton></li>
                    <li>
                        <asp:LinkButton ID="lnkRemoveAllDays" Text="<%$ Resources:AppResource,  SchedulelnkRemoveAllDays %>" runat="server" OnClientClick="RemoveFromAllDays();CloseMenuAndReload();"
                            meta:resourcekey="lnkRemoveAllDaysResource1">Remove from all days</asp:LinkButton></li>
                </ul>
            </div>
        </asp:Panel>
    </div>
 
    <script type="text/javascript">

        var KantechWin = window.document.getElementById("messagePanel");
        var posX;
        var posY;
        var doHide = false;
        var isIE = document.all ? true : false;
        var reloadPageURL = "";
        var reloadPageAction = "";

        document.onmousemove = getMousePosition;
        function getMousePosition(ev) {
 
            if (!isIE) {
                _x = ev.pageX;
                _y = ev.pageY;
            }
            if (isIE) {
                _x = 0;
                _y = 0;
            }
            
            posX = _x;
            posY = _y;
            var pos = Array(posX, posY);
            return pos;
        }

        navHover = function() {
            var lis = document.getElementById("navmenu-v").getElementsByTagName("LI");
            for (var i = 0; i < lis.length; i++) {
                lis[i].onmouseover = function() {
                    this.className += " iehover";
                }
                lis[i].onmouseout = function() {
                    this.className = this.className.replace(new RegExp(" iehover\\b"), "");
                }
            }
        }
        if (window.attachEvent) window.attachEvent("onload", navHover);

        document.forms[0].onmouseup = function() {
            CloseMenu();
        }

        function showMenu(obj, rowID) {
        
            window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value = rowID;

            KantechWin.style.display = "block";

            BrowserVersion = '<%= BrowserVersion %>';
 
            
            if (isIE) {
                posX = window.event.x - obj.offsetLeft;
                posY = window.event.y - obj.offsetTop;
                
                //fix for IE6
                if (BrowserVersion == "IE6")
                    posY = posY + 315;
                    
                this.KantechWin.style.left = posX + -100 + "px";
                this.KantechWin.style.top = posY + -35 + "px";
      
            }
            else { 
                this.KantechWin.style.left = posX + -195 + "px";
                this.KantechWin.style.top = posY + -35 + "px";
            }

            
        }

        function hide() {
            doHide = false;
            KantechWin.style.display = "none";
            this.KantechWin.style.left = "-125px";
            this.KantechWin.style.top = "-125px";
        }


        function CloseMenu() {
            if (doHide) {
                doHide = false;
                KantechWin.style.display = "none";
                this.KantechWin.style.left = "-125px";
                this.KantechWin.style.top = "-125px";
            }
        }
        
        function CloseMenuAndReload() {
            if (doHide) {
                KantechWin.style.display = "none";
                this.KantechWin.style.left = "-125px";
                this.KantechWin.style.top = "-125px";
                checkReload = true;
                doHide = false;
            }
        }


        function closeAlert() {
            var myBehavior = $find("ModalPopupBehaviorMessageOK");
            myBehavior.hide();
        }



        function closeWin() {

            document.forms[0].submit();
        }


        function SetConfirmationActionValue(value) {
            window.document.getElementById('<%=this.MessageConfirmationActionValue.ClientID %>').value = value;
        }

        function checkForReloadPage() {
            if (reloadPageAction == "true") {
                window.location = reloadPageActionURL;
            }
        }

        function callAlertMessage(mess, imagecode, reload, path) {
            AlertMessagePanel(mess, imagecode, reload, path);
        }

        function AlertMessagePanel(msg, code, reload, path) {
            var myBehavior = $find("ModalPopupBehaviorMessageError");
            window.document.getElementById('<%=this.lblMessageError.ClientID %>').innerHTML = msg;
            myBehavior.show();

            if (reload == "true") {
                reloadPageAction = "true";
                pos = location.href.lastIndexOf('/') + 1;
                str = location.href.substring(0, pos);
                reloadPageActionURL = str + path;
            }
            else
                reloadPageAction = "false";
        }


        /**************************************************************/
        /*  Methods related to the check of the grid
        /**************************************************************/
        function ChangeRowColor(row, checked) {

            if (checked == false)
                document.getElementById(previousRow).style.backgroundColor = "#ffffff";
            else
                document.getElementById(row).style.backgroundColor = "#ffffda";
        }

        //Events fire by the mouseover on the gridview
        function OnCellMouseOver(colorChecked, imgUrlChecked, imgUrlUnChecked, cellID) {
            document.getElementById(cellID).style.backgroundColor = colorChecked;
            document.getElementById(cellID).childNodes[0].src = imgUrlChecked;
        }

        //Events fire by mouseout on the gridview
        function OnCellMouseOut(colorUnChecked, colorChecked, imgUrlChecked, imgUrlUnChecked, cellID, isChecked) {
            if (isChecked == true) {
                document.getElementById(cellID).style.backgroundColor = colorChecked;
                document.getElementById(cellID).childNodes[0].src = imgUrlChecked;
            }
            else {
                document.getElementById(cellID).style.backgroundColor = colorUnChecked;
                document.getElementById(cellID).childNodes[0].src = imgUrlUnChecked;
            }
        }

        //Events fire when the user check or uncheck the checkbox
        function OnDayChecked(colorUnChecked, colorChecked, imgUrlChecked, imgUrlUnChecked, cellID, checkBoxControl, rowIndex, cellIndex) {

            var cell=document.getElementById(cellID);
            var imgButton;

            if (isIE) 
                imgButton = document.getElementById(cellID).children[0].children[0];
            else 
                imgButton = cell.getElementsByTagName("div")[0].getElementsByTagName("input")[1];

            
            if (checkBoxControl.checked == false) {
                checkBoxControl.checked = true;
                cell.style.backgroundColor = colorChecked;
                imgButton.src = '<%= GetImgUrlResolved("true") %>';
            }
            else {
                cell.style.backgroundColor = colorUnChecked;
                imgButton.src = '<%= GetImgUrlResolved("false") %>';
                checkBoxControl.checked = false;
            }

            SetDirty();

            //force partial postback
            window.document.getElementById('<%=this.MustCheckCellInfos.ClientID %>').value = rowIndex + "," + cellIndex;
            doPostBackAsync(cellID, '');
        }
        /**************************************************************/


        /**************************************************************/
        /*  Methods related to the opration menu
        /**************************************************************/
        function ApplyToAllDays() {
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk2").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk3").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk4").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk5").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk6").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk7").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk8").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk9").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk10").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk11").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk12").childNodes[0].checked = true;

            RefreshControls();
        }

        function ApplyToAllWeekdays() {
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk2").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk3").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk4").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk5").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk6").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk7").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk8").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk9").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk10").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk11").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk12").childNodes[0].checked = false;
            RefreshControls();
        }

        function ApplyToAllDaysExceptHolidays() {
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk2").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk3").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk4").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk5").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk6").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk7").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk8").childNodes[0].checked = true;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk9").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk10").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk11").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk12").childNodes[0].checked = false;
            RefreshControls();
        }

        function RemoveFromAllDays() {
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk2").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk3").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk4").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk5").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk6").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk7").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk8").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk9").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk10").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk11").childNodes[0].checked = false;
            document.getElementById("row" + window.document.getElementById('<%=this.SelectedRowID.ClientID %>').value + "chk12").childNodes[0].checked = false;
            RefreshControls();
        }

        /**************************************************************/


        //Puts the IsDirty to true to indicates that a modification has been made
        function SetDirty() {
            if (document.getElementById('<%= hfIsDirty.ClientID  %>').value == "0") {
                document.getElementById('<%= btnSave.ClientID  %>').disabled = false;
                document.getElementById('<%= btnCancel.ClientID  %>').disabled = false;
                document.getElementById('<%= hfIsDirty.ClientID  %>').value = "1";
            }
        }

        //Refresh the gridview controls and the buttons based on new data
        function RefreshControls() {
            window.document.getElementById('<%=this.MustRefreshControls.ClientID %>').value = 1;
            __doPostBack('<%= upGateway.ClientID %>', '');
        }

        //Partial Postback to do the Save As Operation
        function SaveAs() {
            window.document.getElementById('<%=this.MustSaveAs.ClientID %>').value = 1;
            __doPostBack('<%=this.upGateway.ClientID %>', '');
        }

        //Partial Postback to add a new record
        function AddNewRecord() {
            window.document.getElementById('<%=this.MustAddNew.ClientID %>').value = 1;
            __doPostBack('<%=this.upButtons.ClientID %>', '');
        }


        function doPostBackAsync(eventName, eventArgs) {
            var prm = Sys.WebForms.PageRequestManager.getInstance();

            if (!Array.contains(prm._asyncPostBackControlIDs, eventName)) {
                prm._asyncPostBackControlIDs.push(eventName);
            }

            if (!Array.contains(prm._asyncPostBackControlClientIDs, eventName)) {
                prm._asyncPostBackControlClientIDs.push(eventName);
            }

            __doPostBack(eventName, eventArgs);
        }


    </script>

</asp:Content>
