﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="InputUC.ascx.cs" Inherits="WebStation.Operation.InputUC" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register Assembly="System.Web.Extensions, Version=1.0.61025.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35"
    Namespace="System.Web.UI" TagPrefix="asp" %>
<%@ Register Src="ActivationTempDelayUC.ascx" TagName="delayUC" TagPrefix="uc1" %>
<asp:ScriptManager ID="ScriptManager1" runat="server">
</asp:ScriptManager>
<input type="hidden" runat="server" id="DelayPopupIsOpen" />
<uc1:delayUC ID="delayPopup" runat="server" />

<script language="javascript">
    var checkReload = false;
    var timerCheck = 0;

    function checkReloadData() {

        if (checkReload) {
            if (timerCheck == 1) {
                timerCheck = 0;
                checkReload = false;
            }
            else {
                //if the delay popup is open we don'T refresh and we wait until the popup is close
                if (document.getElementById('<%=this.DelayPopupIsOpen.ClientID %>').value == 0) {
                    timerCheck++;
                }
                setTimeout("checkReloadData()", 5000);
            }
        }

        //if the delay popup is open we don'T refresh and we wait until the popup is close
        if (document.getElementById('<%=this.DelayPopupIsOpen.ClientID %>').value != 1) {
            postBackHiddenField('<%=HiddenField2.ClientID %>');
        }
    }
    
    function postBackHiddenField(hiddenFieldID) {
        var hiddenField = $get(hiddenFieldID);
        if (hiddenField) {
            hiddenField.value = (new Date()).getTime();
            __doPostBack(hiddenFieldID, '');
        }
    }
</script>

<div id="operationDoor">
    <div id="divGatewayList">
        <asp:GridView CssClass="GridViewDoorList" ID="GridViewRelayList" runat="server" AutoGenerateColumns="False"
            OnRowCommand="myAccessGridView_RowCommand">
            <HeaderStyle CssClass="GridViewDoorListHeader" />
            <Columns>
                <asp:TemplateField HeaderText="<%$ Resources:AppResource, labelGatewaySiteHeader %>">
                    <ItemTemplate>
                        <asp:LinkButton ID="LinkButton1" CssClass="linkBtnDoorList" runat="server" CommandName="ViewInputList"
                            CommandArgument='<%# Eval("PKDATA")%>' Text='<%# Eval("DESCRIPTION")%>'></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div id="divContainerDoor">
        <h2>
            <% = Resources.AppResource.InputTitle%></h2>
        <asp:Label ID="lblTitleRelayList" CssClass="titleDoorList" runat="server" Text="<%$ Resources:AppResource, SelectGatewayLine %>"></asp:Label><br />
        <asp:Button ID="btnRefresh" runat="server" Text="<%$ Resources:AppResource,btnRefresh  %>" />
        <div id="divDoorList">
            <asp:UpdatePanel ID="UpdatePanel1" UpdateMode="Conditional" ChildrenAsTriggers="false"
                runat="server">
                <ContentTemplate>
                    <asp:PlaceHolder ID="PlaceHolder1" runat="server" />
                    <asp:HiddenField ID="HiddenField2" runat="server" />
                </ContentTemplate>
                <Triggers>
                    <asp:AsyncPostBackTrigger ControlID="btnRefresh" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="lnkBtnCloseMenu" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="btnCloseMessageOK" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="lnkBtnInputNormal" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="lnkBtnInputContinuousSupervision" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="lnkBtnInputNoSupervision" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="lnkBtnInputNoSupervisionTempo" EventName="Click" />
                    <asp:AsyncPostBackTrigger ControlID="HiddenField2" EventName="ValueChanged" />
                </Triggers>
            </asp:UpdatePanel>
        </div>
    </div>
    <div id="messagePanel">
        <asp:Panel ID="PanelMenuOperation" runat="server">
            <div id="menuOperation" onmouseout="doHide = 'true';">
                <ul id="navmenu-v">
                    <li>
                        <asp:LinkButton ID="lnkBtnCloseMenu" runat="server" CssClass="CloseMenu" Style="color: Black;
                            background: url(../Common/Images/CloseMenu.jpg);" OnClientClick="hide();"><% = Resources.AppResource.MenuOperationClose%></asp:LinkButton></li>
                    <li>
                        <asp:LinkButton ID="lnkBtnInputNormal" runat="server" OnClientClick="CloseMenuAndReload(true);"
                            OnClick="lnkBtnInputNormal_Click"><% = Resources.AppResource.MenuOperationInputNormal%></asp:LinkButton></li>
                    <li>
                        <asp:LinkButton ID="lnkBtnInputContinuousSupervision" runat="server" OnClientClick="CloseMenuAndReload(true);"
                            OnClick="lnkBtnInputContinuousSupervision_Click"><% = Resources.AppResource.MenuOperationInputContinuousSupervision%></asp:LinkButton></li>
                    <li>
                        <asp:LinkButton ID="lnkBtnInputNoSupervision" runat="server" OnClientClick="CloseMenuAndReload(true);"
                            OnClick="lnkBtnInputNoSupervision_Click"><% = Resources.AppResource.MenuOperationInputNoSupervision%></asp:LinkButton></li>
                    <li>
                        <asp:LinkButton ID="lnkBtnInputNoSupervisionTempo" runat="server" OnClientClick="CloseMenuAndReload(false);"
                            OnClick="lnkBtnInputNoSupervisionTempo_Click"><% = Resources.AppResource.MenuOperationInputNoSupervisionTemporarily%></asp:LinkButton></li>
                </ul>
            </div>
        </asp:Panel>
    </div>
</div>
<input type="hidden" runat="server" id="SelectedDoorID" />
<input type="hidden" runat="server" id="ActionDoorString" />
<div id="MessageOK">
    <asp:Button runat="server" ID="TargetControlForMessageOK" Style="display: none" />
    <ajaxToolkit:ModalPopupExtender runat="server" ID="ModalPopupExtenderMessageOK" BehaviorID="ModalPopupBehaviorMessageOK"
        TargetControlID="TargetControlForMessageOK" PopupControlID="PanelMessageOK" BackgroundCssClass="modalBackground">
    </ajaxToolkit:ModalPopupExtender>
    <asp:Panel ID="PanelMessageOK" runat="server" Style="display: none; padding: 20px"
        CssClass="modalMessage">
        <div>
            <asp:Label runat="server" ID="lblMessageOK"><% = Resources.AppResource.OperationPrivileges%></asp:Label><br />
            <br />
        </div>
        <div style="text-align: center;">
            <asp:Button ID="btnCloseMessageOK" Width="75px" Height="23px" runat="server" Text="<%$ Resources:AppResource, btnOK %>"
                OnClientClick="closeAlert();" />
        </div>
    </asp:Panel>
</div>

<script language="javascript">

    var KantechWin = window.document.getElementById("messagePanel");
    var posX;
    var posY;
    var doHide = false;
    var isIE = document.all ? true : false;
    document.onmousemove = getMousePosition;
    function getMousePosition(ev) {

        if (!isIE) {
            _x = ev.pageX;
            _y = ev.pageY;
        }
        if (isIE) {
            _x = 0;
            _y = 0;
        }
        posX = _x;
        posY = _y;
        var pos = Array(posX, posY);
        return pos;
    }

    function getIEVersion() {
        var version = 0;

        if (navigator.appVersion.indexOf("MSIE") != -1)
            version = parseFloat(navigator.appVersion.split("MSIE")[1]);

        return version;
    }


    navHover = function() {
        var lis = document.getElementById("navmenu-v").getElementsByTagName("LI");
        for (var i = 0; i < lis.length; i++) {
            lis[i].onmouseover = function() {
                this.className += " iehover";
            }
            lis[i].onmouseout = function() {
                this.className = this.className.replace(new RegExp(" iehover\\b"), "");
            }
        }
    }

    if (window.attachEvent) window.attachEvent("onload", navHover);

    document.forms[0].onmouseup = function() {
        CloseMenu();
    }

    function showMenu(obj, pkdata) {
        window.document.getElementById('<%=this.SelectedDoorID.ClientID %>').value = pkdata;
        KantechWin.style.display = "block";
        if (isIE) {
            var version = getIEVersion();

            var xOffset = 200;
            var yOffset = 50;

            if (version == 6) {
                var pos = findPositionWithScrolling(obj);
                x = pos[0];
                y = pos[1];

                var size = getWindowSize();
                var width = size[0];
                var height = size[1];

                xOffset = (width - 1024) / 2;

                this.KantechWin.style.left = (x - xOffset) + "px";
                this.KantechWin.style.top = (y + yOffset) + "px";
            }
            else {
                this.KantechWin.style.left = obj.offsetParent.offsetLeft + obj.offsetLeft + xOffset + "px";
                this.KantechWin.style.top = obj.offsetParent.offsetTop + obj.offsetTop + yOffset + "px";
            }
        }
        else {
            this.KantechWin.style.left = obj.offsetLeft + 50 + "px";
            this.KantechWin.style.top = obj.offsetTop + 50 + "px";
        }
    }

    function findPositionWithScrolling(oElement) {
        if (typeof (oElement.offsetParent) != 'undefined') {
            var originalElement = oElement;
            for (var posX = 0, posY = 0; oElement; oElement = oElement.offsetParent) {
                posX += oElement.offsetLeft;
                posY += oElement.offsetTop;
                if (oElement != originalElement && oElement != document.body && oElement != document.documentElement) {
                    posX -= oElement.scrollLeft;
                    posY -= oElement.scrollTop;
                }
            }
            return [posX, posY];
        } else {
            return [oElement.x, oElement.y];
        }
    }

    function getWindowSize() {
        var myWidth = 0, myHeight = 0;
        if (typeof (window.innerWidth) == 'number') {
            //Non-IE
            myWidth = window.innerWidth;
            myHeight = window.innerHeight;
        } else if (document.documentElement && (document.documentElement.clientWidth || document.documentElement.clientHeight)) {
            //IE 6+ in 'standards compliant mode'
            myWidth = document.documentElement.clientWidth;
            myHeight = document.documentElement.clientHeight;
        } else if (document.body && (document.body.clientWidth || document.body.clientHeight)) {
            //IE 4 compatible
            myWidth = document.body.clientWidth;
            myHeight = document.body.clientHeight;
        }

        return [myWidth, myHeight];
    }

    function getY(oElement) {
        var iReturnValue = 0;
        while (oElement != null) {
            iReturnValue += oElement.offsetTop;
            oElement = oElement.offsetParent;
        }
        return iReturnValue;
    }

    function getX(oElement) {
        var iReturnValue = 0;
        while (oElement != null) {
            iReturnValue += oElement.offsetLeft;
            oElement = oElement.offsetParent;
        }
        return iReturnValue;
    }

    function hide() {
        doHide = false;
        window.document.getElementById('<%=this.SelectedDoorID.ClientID %>').value = "";
        KantechWin.style.display = "none";
        this.KantechWin.style.left = "-125px";
        this.KantechWin.style.top = "-125px";
    }

    function CloseMenu() {
        if (doHide) {
            doHide = false;
            KantechWin.style.display = "none";
            this.KantechWin.style.left = "-125px";
            this.KantechWin.style.top = "-125px";
        }
    }

    //close the menu and start the reload timer if requested
    function CloseMenuAndReload(reload) {
        KantechWin.style.display = "none";
        this.KantechWin.style.left = "-125px";
        this.KantechWin.style.top = "-125px";

        if (reload == true) {
            startReload();
        }
    }

    function startReload() {
        checkReload = true;
        postBackHiddenField('<%=HiddenField2.ClientID %>');
        setTimeout("checkReloadData()", 5000);
    }

    function closeAlert() {
        var myBehavior = $find("ModalPopupBehaviorMessageOK");
        myBehavior.hide();
    }
 
</script>

