<%@ Control Language="C#" AutoEventWireup="True" CodeBehind="EditAddCardUC.ascx.cs"
    Inherits="WebStation.CardManager.EditAddCardUC" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="AjaxToolkit" %>
<%@ Register Assembly="System.Web.Extensions, Version=1.0.61025.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35"
    Namespace="System.Web.UI" TagPrefix="asp" %>
 
<AjaxToolkit:ToolkitScriptManager ID="ScriptManager1" runat="server" EnableScriptGlobalization="true"
    EnableScriptLocalization="true" />
<script type="text/javascript" src="../Common/JavaScript/Silverlight.js"></script>
<script type="text/javascript" src="../Common/JavaScript/prototype.js"></script>
<input type="hidden" runat="server" id="ApplyCustomizationChange" />
<input type="hidden" runat="server" id="SilverlightError" />
<input type="hidden" runat="server" id="ModifyAddCard_Answer" />
<input type="hidden" runat="server" id="sectionToOpen" />
<input type="hidden" runat="server" id="RowForAccessLevelSecondarySelected" />
<input type="hidden" runat="server" id="AccessLevelSecondarySelected" />
<input type="hidden" runat="server" id="ReloadAccessLevelSelected" />
<input type="hidden" runat="server" id="formatDate" />
<input type="hidden" runat="server" id="dateSeparator" />
<input type="hidden" runat="server" id="MustSaveSignaturePad" />
<input type="hidden" runat="server" id="MustSavePicCaptureStream" />
<input type="hidden" runat="server" id="MustClosePicCapture" />


<input type="hidden" runat="server" id="PictureCaptureLength" />
<input type="hidden" runat="server" id="PictureCaptureContent" />

<script language="Javascript">

    function pageLoad() {
        //centerModal();
    }

    function centerModal() {
        // SecondaryModalPopupBehavior
        //var j = $find('<%=SecondaryModalPopup.ClientID %>');
        var j = $find("SecondaryModalPopupBehavior");
        //j.set_X((getWidth() - 650) / 2);
        //j.set_Y((getHeight() - 435) / 2);

        j.set_X(0);
        j.set_Y(0);
    } 

    function getHeight() {
        var myHeight = 0;
        if (typeof (window.innerWidth) == 'number') {
            //Non-IE
            myHeight = window.innerHeight;
        } else if (document.documentElement && (document.documentElement.clientWidth || document.documentElement.clientHeight)) {
            //IE 6+ in 'standards compliant mode'
            myHeight = document.documentElement.clientHeight;
        } else if (document.body && (document.body.clientWidth || document.body.clientHeight)) {
            //IE 4 compatible
            myHeight = document.body.clientHeight;
        }
        return myHeight;
    }

    function getWidth() {
        var myWidth = 0;
        if (typeof (window.innerWidth) == 'number') {
            //Non-IE
            myWidth = window.innerWidth;
        } else if (document.documentElement && (document.documentElement.clientWidth || document.documentElement.clientHeight)) {
            //IE 6+ in 'standards compliant mode'
            myWidth = document.documentElement.clientWidth;
        } else if (document.body && (document.body.clientWidth || document.body.clientHeight)) {
            //IE 4 compatible
            myHeight = document.body.clientWidth;
        }
        return myWidth;
    }




    function CancelPicCapture() {
        var myBehavior = $find("ModalPicCaptureBehavior");
        myBehavior.hide();
        ShowEventApp();
    }

    function SavePicCapture(pictureContent, pictureLength) {
        window.document.getElementById('<%=this.MustSavePicCaptureStream.ClientID %>').value = pictureContent;
        window.document.getElementById('<%=this.PictureCaptureContent.ClientID %>').value = pictureContent;
        window.document.getElementById('<%=this.PictureCaptureLength.ClientID %>').value = pictureLength;
        var myBehavior = $find("ModalPicCaptureBehavior");
        myBehavior.hide();
         __doPostBack('', '');
    }

    function CancelSignaturePad() {
        ResetSignaturePad();
        //force postback to remove the activex object
        __doPostBack('', '');
    }

    function ResetSignaturePad() {
        //in case the signaturepad active x is not properly loaded, we put the try catch
        try {
            document.getElementById("SigPlus1").ClearTablet();
        }
        catch (err) {
        }
    }

    //This function is called when the user sign and submit a signature pad
    function OnSaveSignaturePad() {
        if (document.getElementById("SigPlus1").NumberOfTabletPoints > 0) {
            document.getElementById("SigPlus1").TabletState = 0; //Turns tablet off
            document.getElementById("SigPlus1").AutoKeyStart();

            document.getElementById("SigPlus1").AutoKeyData = document.getElementById('<%=this.txtName.ClientID %>').value;
            //pass here the data you want to use to encrypt the signature
            //this demo simply encrypts to the name typed in by the user
            //you'll probably want to make sure your encryption data you use is
            //more useful...that you encrypt the signature to the data important
            //to your app, and what the client has agreed to

            document.getElementById("SigPlus1").AutoKeyFinish();
            document.getElementById("SigPlus1").EncryptionMode = 2;
            document.getElementById("SigPlus1").SigCompressionMode = 1;
            
            document.getElementById("SigPlus1").DisplayPenWidth=<%= SignaturePadPenWidth %>
            document.getElementById("SigPlus1").ImagePenWidth=<%= SignaturePadPenWidth %> 

            document.getElementById('<%=this.hiddenSignaturePad.ClientID %>').value = document.getElementById("SigPlus1").SigString;
            //pass the signature ASCII hex string to the hidden field,
            //so it will be automatically passed when the page is submitted

            window.document.getElementById('<%=this.MustSaveSignaturePad.ClientID %>').value = 1;
            __doPostBack('', '');
        }
        else {
            alert('<%=Resources.AppResource.signbeforeContinuing%>')
            return false;
        }
    }

    /*SILVERLIGHT METHODS*/
    var silverlightControl = null;
 
    //event when the silverlight control is loaded
    function onSilverLightPicCaptureLoaded(sender, args) {
        silverlightControl = document.getElementById('silverlightPicCaptureControl');
    }

    //Catch Silverlight Error 
    //and force a post back in order to throw it to asp.net
    function onSilverlightError(sender, args) {
        var appSource = "";
        if (sender != null && sender != 0) {
            appSource = sender.getHost().Source;
        }

        var errorType = args.ErrorType;
        var iErrorCode = args.ErrorCode;

        if (errorType == "ImageError" || errorType == "MediaError") {
            return;
        }

        var errMsg = "Unhandled Error in Silverlight Application " + appSource + "\n";

        errMsg += "Code: " + iErrorCode + "    \n";
        errMsg += "Category: " + errorType + "       \n";
        errMsg += "Message: " + args.ErrorMessage + "     \n";

        if (errorType == "ParserError") {
            errMsg += "File: " + args.xamlFile + "     \n";
            errMsg += "Line: " + args.lineNumber + "     \n";
            errMsg += "Position: " + args.charPosition + "     \n";
        }
        else if (errorType == "RuntimeError") {
            if (args.lineNumber != 0) {
                errMsg += "Line: " + args.lineNumber + "     \n";
                errMsg += "Position: " + args.charPosition + "     \n";
            }
            errMsg += "MethodName: " + args.methodName + "     \n";
        }

        window.document.getElementById('<%=this.SilverlightError.ClientID %>').value = errMsg.escapeHTML();

        __doPostBack('', '');
    }


    function setSilverlightSize(val) {
        var host = document.getElementById("silverlightPicCaptureHost"); host.style.height = val + "px";
    }

    //Hides the Event app when we use another silverlight app
    function HideEventApp() {
        var ie = (document.all && !window.opera) ? true : false;

        //For all browser except firefox 
        if (ie) {
            silverlightControl = document.getElementById('silverlightEventViewerHost');
            if(silverlightControl != null)
                silverlightEventViewerHost.style.display = "none";
        }
    }

    //Hides/Show the Event app when we use another silverlight app
    function ShowEventApp() {
        var ie = (document.all && !window.opera) ? true : false;

        //For all browser except firefox 
        if (ie) {
            silverlightControl = document.getElementById('silverlightEventViewerHost');
            if(silverlightControl != null)
                silverlightEventViewerHost.style.display = '';
        }
    }


</script>

<div id="divWindowPicCapture">
<asp:Button runat="server" ID="btnPicCaptureHidden" Style="display: none" />  

    <AjaxToolkit:ModalPopupExtender ID="ModalPopupExtenderPicCapture" runat="server"
         DynamicServicePath="" Enabled="True" PopupControlID="PanelPicCapture" BehaviorID="ModalPicCaptureBehavior"
         TargetControlID="btnPicCaptureHidden" BackgroundCssClass="modalBackground" />
          <asp:Panel ID="PanelPicCapture" runat="server" Style="display: none;" CssClass="modalPicCapture">

        <div id="silverlightPicCaptureHost">
            <object data="data:application/x-silverlight-2," type="application/x-silverlight-2"
                width="100%" height="100%" id="silverlightPicCaptureControl">
                <param name="source" value="../ClientBin/Kantech.Silverlight.PicCapture.xap" />
                <param name="onError" value="onSilverlightError" />
                <param name="background" value="white" />
                <param name="minRuntimeVersion" value="4.0.50524.0" />
                <param name="onerror" value="onSilverlightError" />
                <param name="onload" value="onSilverLightPicCaptureLoaded" />
                <param name="autoUpgrade" value="true" />
                <param name="Windowless" value="false" />            
                <param name="EnableGPUAcceleration" value="true" />
                <param runat="server" name="initParams" id="SilverLightInitParams" value="" />
                <a href="http://go.microsoft.com/fwlink/?LinkID=149156&v=4.0.50524.0" style="text-decoration: none">
                    <img src="http://go.microsoft.com/fwlink/?LinkId=161376" alt="Get Microsoft Silverlight"
                        style="border-style: none" />
                </a>
            </object>

        </div>
        </asp:Panel>
 
</div>

<div id="divWindowSignaturePad">
    <asp:Button runat="server" ID="btnSignaturePadHidden" Style="display: none" />
    <AjaxToolkit:ConfirmButtonExtender ID="ConfirmButtonExtenderSignaturePad" runat="server"
        TargetControlID="btnSignaturePadHidden" DisplayModalPopupID="ModalPopupExtenderSignaturePad"
        BehaviorID="signaturePadPopupBehavior" />
    <AjaxToolkit:ModalPopupExtender ID="ModalPopupExtenderSignaturePad" runat="server"
        CancelControlID="btnSignaturePadCancel" DynamicServicePath="" Enabled="True"
        PopupControlID="PanelSignaturePad" TargetControlID="btnSignaturePadHidden" BackgroundCssClass="modalBackground" />
    <asp:Panel ID="PanelSignaturePad" runat="server" Style="display: none; padding: 20px"
        CssClass="modalSignaturePad">
        <asp:HiddenField runat="server" ID="txtName" />
        <asp:Label runat="server" ID="lblSignaturePadInvite" CssClass="SignaturePadInvite"></asp:Label>
        <br/>
        <br/>
        <table border="0" cellpadding="0">
            <tr>
                <td>
                    <div id="divSignaturePadImage">
                        <img id="SignaturePadImage" src="../Common/Images/SignaturePad/signaturePad.bmp"
                            height="300" />
                    </div>
                    <div runat="server" id="divSigPlus" class="divSigPlus">
                        <%-- The ActiveX object Signature pad is added on the server side--%>
                    </div>
                </td>
            </tr>
        </table>
        <div id="divSignaturePadButtons">
            <button id="btnSignaturePadCancel" onclick="CancelSignaturePad()" style="height:27px;">
                <%=Resources.AppResource.btnCancel%></button>
            &nbsp;&nbsp;&nbsp;&nbsp;
            <button id="btnSignaturePadClear" onclick="ResetSignaturePad()" class="SignaturePadButtons"  >
                <%=Resources.AppResource.ClearSignaturePad%></button>
            &nbsp;&nbsp;&nbsp;&nbsp;
            <button id="btnSignaturePadSubmit" onclick="OnSaveSignaturePad()" class="SignaturePadButtons">
                <%=Resources.AppResource.btnOK%></button>
            <input id="hiddenSignaturePad" type="hidden" name="hiddenSignaturePad" runat="server"/>
        </div>
    </asp:Panel>
</div>
<div id="EditCard">
    <script language="javascript">
        var ModifyAddCard_UserName = "<% = ModifyAddCard_UserName_ServerSide %>";
        var ModifyAddCard_CardNumber = "<% = ModifyAddCard_CardNumber_ServerSide %>";
        var ModifyAddCard_EditMod = "<% = ModifyAddCard_EditMod_ServerSide %>";
        var oldSectionSelected = "divComment";
        var OldCardState = null;
        var reloadPageURL = "";
        var reloadPageAction = "";
 




        function ConvertToDateFormat(dateToConvert) {

            var format = window.document.getElementById('<%=this.formatDate.ClientID %>').value
            var newDate = new Date();
            var day = "";
            var month = "";
            var year = "";
            var n_month = 0;

            for (i = 0; i < format.length; i++) {

                if (format.substring(i, i + 1) == "d" || format.substring(i, i + 1) == "D")
                    day += dateToConvert.substring(i, i + 1);
                if (format.substring(i, i + 1) == "m" || format.substring(i, i + 1) == "M")
                    month += dateToConvert.substring(i, i + 1);
                if (format.substring(i, i + 1) == "y" || format.substring(i, i + 1) == "Y")
                    year += dateToConvert.substring(i, i + 1);
            }

            n_month = parseInt(month, 10) - 1;
            newDate.setFullYear(year, n_month, day);
            return newDate;
        }

        function checkMaxLength(obj) {
            if (obj.value.length > 255) {
                obj.value = obj.value.substring(0, 255)
            }
        }
        function GetRadWindow() {
            var oWindow = null;
            if (window.radWindow) oWindow = window.radWindow; //Will work in Moz in all cases, including clasic dialog   
            else if (window.frameElement.radWindow) oWindow = window.frameElement.radWindow; //IE (and Moz az well)   

            return oWindow;
        }

        function CancelEdit() {
            GetRadWindow().Close();
        }

        function CancelReload() {
            GetRadWindow().Reload();
        }


        function checkUserName() {
            var myString = trimText(window.document.getElementById('<%=this.txtUserName.ClientID %>').value);

            if (myString == "") {
                callAlertMessage('<%= Resources.AppResource.errorNameRequired %>', 0, false);
                window.document.getElementById('<%=this.txtUserName.ClientID %>').value = "";
                return false;
            }
            else
                return true;

        }
        function trimText(obj) {
            return obj.replace(/^\s+|\s+$/g, "");
        }

        function insertZero() {
            var orginalValue = window.document.getElementById('<%=this.txtPinNumber.ClientID %>').value;
            var length = window.document.getElementById('<%=this.txtPinNumber.ClientID %>').value.length;
            var pd = '';

            if (length < PINLENGTH)
            { for (i = 0; i < (PINLENGTH - length); i++) { pd += '0'; } }

            window.document.getElementById('<%=this.txtPinNumber.ClientID %>').value = pd + orginalValue;



        }
        function PinValidate() {
            var pinNum = window.document.getElementById('<%=this.txtPinNumber.ClientID %>');

            if (pinNum.value == "") {
                callAlertMessage('<%= Resources.AppResource.InvalidPinNumber %>', 48, false);
            }
            else {


                if (!IsNumeric(pinNum.value.substring(0, pinNum.value.length))) {

                    if (PINLENGTH == 5) {
                        window.document.getElementById('<%=this.txtPinNumber.ClientID %>').value = "00000";
                    }
                    else {
                        window.document.getElementById('<%=this.txtPinNumber.ClientID %>').value = "000000";
                    }
                    callAlertMessage('Invalid character', 0, false);
                }
                else {
                    if (PINLENGTH == 5) {
                        if (pinNum.value > 65535) {
                            callAlertMessage('<%= Resources.AppResource.PinNumberMax %>', 32, false);
                            window.document.getElementById('<%=this.txtPinNumber.ClientID %>').value = 65535;
                            return false;
                        }
                    }
                }


            }

        }
        function IsNumeric(strString) {

            var strValidChars = "0123456789";
            var strChar;
            var blnResult = true;

            if (strString.length == 0) return false;
            for (i = 0; i < strString.length && blnResult == true; i++) {
                strChar = strString.charAt(i);
                if (strValidChars.indexOf(strChar) == -1) {
                    blnResult = false;
                }
            }
            return blnResult;
        }
        function checkCardNumber(obj) {
            if (!IsValidNumber(obj.value)) {
                if (obj.value.length > 0) {
                    obj.value = deleteInvalidC(obj.value);
                    callAlertMessage('<%= Resources.AppResource.InvalidCharacter %>', 0, false);

                }
            }
        }

        function IsValidNumber(strString) {

            var strValidChars = "0123456789ABCDEFabcdef:";
            var strChar;
            var blnResult = true;

            if (strString.length == 0) return false;
            for (i = 0; i < strString.length && blnResult == true; i++) {
                strChar = strString.charAt(i);
                if (strValidChars.indexOf(strChar) == -1) {
                    blnResult = false;
                }
            }
            return blnResult;
        }
        function deleteInvalidC(strString) {

            var strValidChars = "0123456789ABCDEFabcdef:";
            var strChar;
            var blnResult = true;
            var stringReturn = "";
            if (strString.length == 0) return "";
            for (i = 0; i < strString.length && blnResult == true; i++) {
                strChar = strString.charAt(i);
                if (strValidChars.indexOf(strChar) != -1) {
                    stringReturn += strChar;
                }

            }
            if (stringReturn == "false")
                return "";
            else
                return stringReturn;
        }
        function ValidatedDate() {
            var StartDataValue = window.document.getElementById('<%=this.ajaxStartDate.ClientID %>').value;
            if (StartDataValue == "") {
                callAlertMessage('<%= Resources.AppResource.InvalidOrEmptyStartDate %>', 48, false);
                return false;
            }
            var EndDataValue = window.document.getElementById('<%=this.ajaxEndDate.ClientID %>').value;

            var ddlUseEndData = window.document.getElementById('<%=this.cboUsingEndDate.ClientID %>');


            if (ddlUseEndData.checked) {
                if (EndDataValue == "") {
                    callAlertMessage('<%= Resources.AppResource.InvalidOrEmptyEndDate %>', 48, false);
                    return false;
                }

                if (DateInDays(ConvertToDateFormat(StartDataValue)) >= DateInDays(ConvertToDateFormat(EndDataValue))) {
                    callAlertMessage('<%= Resources.AppResource.EndDateMustBeAfterStart %>', 48, false);
                    return false;
                }
                else
                    return true;
            }
            else
                return true;

        }
        function ValidatedMandatory() {

            var boolAllOK = true;
            var stringToAddToMessage = "";
            if (MandetoryCardInfo1 == 1) {

                if (window.document.getElementById('<%=this.txtCardInfo1.ClientID %>').value == "" || window.document.getElementById('<%=this.txtCardInfo1.ClientID %>').value == " ") {
                    boolAllOK = false;
                    stringToAddToMessage += " " + lblMandetoryCardInfo1 + "\n";
                }

            }
            if (MandetoryCardInfo2 == 1) {

                if (window.document.getElementById('<%=this.txtCardInfo2.ClientID %>').value == "" || window.document.getElementById('<%=this.txtCardInfo2.ClientID %>').value == " ") {
                    boolAllOK = false;
                    stringToAddToMessage += " " + lblMandetoryCardInfo2 + "\n";
                }
            }
            if (MandetoryCardInfo3 == 1) {

                if (window.document.getElementById('<%=this.txtCardInfo3.ClientID %>').value == "" || window.document.getElementById('<%=this.txtCardInfo3.ClientID %>').value == " ") {
                    boolAllOK = false;
                    stringToAddToMessage += " " + lblMandetoryCardInfo3 + "\n";
                }
            }
            if (MandetoryCardInfo4 == 1) {

                if (window.document.getElementById('<%=this.txtCardInfo4.ClientID %>').value == "" || window.document.getElementById('<%=this.txtCardInfo4.ClientID %>').value == " ") {
                    boolAllOK = false;
                    stringToAddToMessage += " " + lblMandetoryCardInfo4 + "\n";
                }
            }
            if (MandetoryCardInfo5 == 1) {

                if (window.document.getElementById('<%=this.txtCardInfo5.ClientID %>').value == "" || window.document.getElementById('<%=this.txtCardInfo5.ClientID %>').value == " ") {
                    boolAllOK = false;
                    stringToAddToMessage += " " + lblMandetoryCardInfo5 + "\n";
                }
            }
            if (MandetoryCardInfo6 == 1) {

                if (window.document.getElementById('<%=this.txtCardInfo6.ClientID %>').value == "" || window.document.getElementById('<%=this.txtCardInfo6.ClientID %>').value == " ") {
                    boolAllOK = false;
                    stringToAddToMessage += " " + lblMandetoryCardInfo6 + "\n";
                }
            }
            if (MandetoryCardInfo7 == 1) {

                if (window.document.getElementById('<%=this.txtCardInfo7.ClientID %>').value == "" || window.document.getElementById('<%=this.txtCardInfo7.ClientID %>').value == " ") {
                    boolAllOK = false;
                    stringToAddToMessage += " " + lblMandetoryCardInfo7 + "\n";
                }
            }
            if (MandetoryCardInfo8 == 1) {

                if (window.document.getElementById('<%=this.txtCardInfo8.ClientID %>').value == "" || window.document.getElementById('<%=this.txtCardInfo8.ClientID %>').value == " ") {
                    boolAllOK = false;
                    stringToAddToMessage += " " + lblMandetoryCardInfo8 + "\n";
                }
            }
            if (MandetoryCardInfo9 == 1) {

                if (window.document.getElementById('<%=this.txtCardInfo9.ClientID %>').value == "" || window.document.getElementById('<%=this.txtCardInfo9.ClientID %>').value == " ") {
                    boolAllOK = false;
                    stringToAddToMessage += " " + lblMandetoryCardInfo9 + "\n";
                }
            }
            if (MandetoryCardInfo10 == 1) {

                if (window.document.getElementById('<%=this.txtCardInfo10.ClientID %>').value == "" || window.document.getElementById('<%=this.txtCardInfo10.ClientID %>').value == " ") {
                    boolAllOK = false;
                    stringToAddToMessage += " " + lblMandetoryCardInfo10 + "\n";
                }
            }

            if (boolAllOK)
                return true
            else {

                callAlertMessage("<%= Resources.AppResource.txtFieldCannotBeEmpty %>" + "\n" + stringToAddToMessage, 48, false);
                return false;
            }

        }
        function EnabledDisabled(cbo, div) {
            var divObj = window.document.getElementById(div);
            if (cbo.checked)
                divObj.style.display = 'block';
            else
                divObj.style.display = 'none';
        }
        function callAlertMessage(mess, imagecode, reload, path) {

            AlertMessagePanel(mess, imagecode, reload, path);

        }
        function hideObject(objName) {
            window.document.getElementById(objName).style.display = 'none';
        }


        //Added by JPM 
        //25 janvier 2010
        function disableObject(objName) {
            window.document.getElementById(objName).disabled = "true";
        }


        function checkFileUpload() {
            var fileUpload = window.document.getElementById('<%=this.realField.ClientID %>');


            var ext = fileUpload.value;
            if (ext == "")
                return true;
            else {
                ext = ext.substring(ext.length - 3, ext.length);
                ext = ext.toLowerCase();
                if (ext == 'jpg' || ext == 'gif' || ext == 'png')
                    return true;
                else {
                    callAlertMessage('<%= Resources.AppResource.invalidFileLoading %>', 64, false);
                    return false;
                }


            }
        }
        function checkValidateAllField() {

            if (checkFileUpload()) {
                if (checkUserName()) {
                    if (ValidatedDate())
                        return (ValidatedMandatory())
                    else
                        return false;
                }
                else
                    return false;
            }
            else
                return false;

        }
        /****************************** CALENDAR FUNCTION ********************************************************************/
        function DateInDays(date) {
            return Math.ceil(date / (1000 * 60 * 60 * 24)); // retourne la date en nombre de jours depuis le 1 janvier 1970
        }

        function checkEXPIRED() {

            var UsingEndDate = window.document.getElementById('<%=this.cboUsingEndDate.ClientID %>');
            var CardState = window.document.getElementById('<%=this.ddlCardState.ClientID %>');
            var today = new Date();
            today = today.format(window.document.getElementById('<%=this.formatDate.ClientID %>').value);
            var endDate = window.document.getElementById('<%=this.ajaxEndDate.ClientID %>').value;

            if (UsingEndDate.checked)
                return (DateInDays(ConvertToDateFormat(endDate)) < DateInDays(ConvertToDateFormat(today)));
            else
                return false;
        }

        function CalValStartDate(sDate) {
            var CardState = window.document.getElementById('<%=this.ddlCardState.ClientID %>');
            var today = new Date();
            today.format(window.document.getElementById('<%=this.formatDate.ClientID %>').value);

            if (DateInDays(ConvertToDateFormat(sDate.value)) > DateInDays(today))
                CardState.selectedIndex = 3 // "PENDING"
            else {
                if ((CardState.value.substring(CardState.value.length - 4, CardState.value.length) != "LOST") && (CardState.value != "EXPIRED") && (CardState.value != "INVALID")) {
                    if (checkEXPIRED())
                        CardState.selectedIndex = 4
                    else
                        CardState.selectedIndex = 0
                }
            }
        }

        function CalValEndDate(sDate) {
            checkEndDateIsEmpty();
            var CardState = window.document.getElementById('<%=this.ddlCardState.ClientID %>');

            if ((CardState.value.substring(CardState.value.length - 4, CardState.value.length) != "LOST") && (CardState.value != "PENDING") && (CardState.value != "INVALID")) {
                if (checkEXPIRED())
                    CardState.selectedIndex = 4
                else
                    CardState.selectedIndex = 0
            }
        }
        function checkEndDateIsEmpty() {
            var cboUseEndDate = window.document.getElementById('<%=this.cboUsingEndDate.ClientID %>');
            var endDate = window.document.getElementById('<%=this.ajaxEndDate.ClientID %>').value;
            if (endDate == "" || endDate == " ") {
                cboUseEndDate.checked = false;
            }
            else {
                cboUseEndDate.checked = true;
            }
        }
        function EnableOrDisableEndDate1(obj) {

            var cal = window.document.getElementById('<%=this.btnEndDate1.ClientID %>');
            var endDate = window.document.getElementById('<%=this.EndDate1.ClientID %>');
            var today = new Date();
            today = today.format(window.document.getElementById('<%=this.formatDate.ClientID %>').value);

            if (obj.checked) {
                cal.Enabled = true;
                endDate.Enabled = true;
                endDate.value = today;
            }
            else {
                cal.Enabled = false;
                endDate.Enabled = false;
                endDate.value = "";
            }
        }
        function EnableOrDisableEndDate2(obj) {
            var cal = window.document.getElementById('<%=this.btnEndDate2.ClientID %>');
            var endDate = window.document.getElementById('<%=this.EndDate2.ClientID %>');
            var today = new Date();
            today = today.format(window.document.getElementById('<%=this.formatDate.ClientID %>').value);

            if (obj.checked) {
                cal.Enabled = true;
                endDate.Enabled = true;
                endDate.value = today;
            }
            else {
                cal.Enabled = false;
                endDate.Enabled = false;
                endDate.value = "";
            }
        }
        function EnableOrDisableEndDate3(obj) {
            var cal = window.document.getElementById('<%=this.btnEndDate3.ClientID %>');
            var endDate = window.document.getElementById('<%=this.EndDate3.ClientID %>');
            var today = new Date();
            today = today.format(window.document.getElementById('<%=this.formatDate.ClientID %>').value);

            if (obj.checked) {
                cal.Enabled = true;
                endDate.Enabled = true;
                endDate.value = today;
            }
            else {
                cal.Enabled = false;
                endDate.Enabled = false;
                endDate.value = "";
            }
        }
        function EnableOrDisableEndDate4(obj) {
            var cal = window.document.getElementById('<%=this.btnEndDate4.ClientID %>');
            var endDate = window.document.getElementById('<%=this.EndDate4.ClientID %>');
            var today = new Date();
            today = today.format(window.document.getElementById('<%=this.formatDate.ClientID %>').value);

            if (obj.checked) {
                cal.Enabled = true;
                endDate.Enabled = true;
                endDate.value = today;
            }
            else {
                cal.Enabled = false;
                endDate.Enabled = false;
                endDate.value = "";
            }
        }
        function EnableOrDisableEndDate5(obj) {
            var cal = window.document.getElementById('<%=this.btnEndDate5.ClientID %>');
            var endDate = window.document.getElementById('<%=this.EndDate5.ClientID %>');
            var today = new Date();
            today = today.format(window.document.getElementById('<%=this.formatDate.ClientID %>').value);

            if (obj.checked) {
                cal.Enabled = true;
                endDate.Enabled = true;
                endDate.value = today;
            }
            else {
                cal.Enabled = false;
                endDate.Enabled = false;
                endDate.value = "";
            }
        }
        function EnableOrDisableEndDate(obj) {
            var CardState = window.document.getElementById('<%=this.ddlCardState.ClientID %>');
            var cal = window.document.getElementById('<%=this.btnImageEndDate.ClientID %>');
            var endDate = window.document.getElementById('<%=this.ajaxEndDate.ClientID %>');
            var StartDate = window.document.getElementById('<%=this.ajaxStartDate.ClientID %>');
            var today = new Date();
            today = today.format(window.document.getElementById('<%=this.formatDate.ClientID %>').value);

            if (obj.checked) {
                cal.Enabled = true;
                endDate.Enabled = true;
                var firstDate = StartDate.value;
                var secondDate = today;
                if (firstDate == secondDate) {
                    var myDate = new Date();
                    myDate.setDate(myDate.getDate() + 1);
                    myDate = myDate.format(window.document.getElementById('<%=this.formatDate.ClientID %>').value);
                    today = myDate;
                }
                endDate.value = today;

                if ((CardState.value.substring(CardState.value.length - 4, CardState.value.length) != "LOST") && (CardState.value != "PENDING") && (CardState.value != "INVALID")) {
                    if (checkEXPIRED())
                        CardState.selectedIndex = 4
                    else
                        CardState.selectedIndex = 0
                }
            }
            else {
                cal.Enabled = false;
                endDate.Enabled = false;
                endDate.value = "";

                if ((CardState.value.substring(CardState.value.length - 4, CardState.value.length) != "LOST") && (CardState.value != "PENDING") && (CardState.value != "INVALID")) {
                    if (checkEXPIRED())
                        CardState.selectedIndex = 4
                    else
                        CardState.selectedIndex = 0
                }
            }
        }
        /*********************************************************************************/
        function EnableOrDisableSupervisorLevel(obj) {

            var SupervisorLevel = window.document.getElementById('<%=this.ddlSupervisorLevel.ClientID %>');

            if (obj.checked) {
                SupervisorLevel.disabled = true;
            }
            else {
                SupervisorLevel.disabled = false;
            }
        }
        function AskQuestion(obj) {
            var CardNumber = window.document.getElementById('<%=this.txtCardNumber.ClientID %>').value;
            var CardNumber2 = window.document.getElementById('<%=this.txtCardNumber2.ClientID %>').value;
            var CardNumber3 = window.document.getElementById('<%=this.txtCardNumber3.ClientID %>').value;
            var CardNumber4 = window.document.getElementById('<%=this.txtCardNumber4.ClientID %>').value;
            var CardNumber5 = window.document.getElementById('<%=this.txtCardNumber5.ClientID %>').value;
            var Answer = window.document.getElementById('<%=this.ModifyAddCard_Answer.ClientID %>').value;

            if (ModifyAddCard_EditMod) {

                if (ModifyAddCard_CardNumber != "") {

                    if (ModifyAddCard_CardNumber == CardNumber || ModifyAddCard_CardNumber == CardNumber2 || ModifyAddCard_CardNumber == CardNumber3 || ModifyAddCard_CardNumber == CardNumber4 || ModifyAddCard_CardNumber == CardNumber5) {

                        if (Answer == "") {

                            if (obj.value != ModifyAddCard_UserName) {
                                window.document.getElementById('<%=this.btnCancel.ClientID %>').focus();
                                var myBehavior = $find("ModalPopupBehaviorMessageYesNoJavascript");
                                myBehavior.show();
                            }
                        }
                    }
                }
            }
        }

        /*********************************************************************************/




        function rolloverTab(strSection) {
            window.document.getElementById(strSection + "_Container").style.cursor = 'hand';
            window.document.getElementById(strSection + "_Left").className = "LeftImg_on";
            window.document.getElementById(strSection + "_Container").className = "ContainerImg_on";
            window.document.getElementById(strSection + "_Right").className = "RightImg_on";
        }

        function rolloutTab(strSection) {
            if (window.document.getElementById('<%=this.sectionToOpen.ClientID %>').value != strSection) {
                window.document.getElementById(strSection + "_Container").style.cursor = 'default';
                window.document.getElementById(strSection + "_Left").className = "LeftImg_off";
                window.document.getElementById(strSection + "_Container").className = "ContainerImg_off";
                window.document.getElementById(strSection + "_Right").className = "RightImg_off";
            }
        }

        function AlertMessagePanel(msg, code, reload, path) {
            var myBehavior = $find("ModalPopupBehaviorMessageError");
            window.document.getElementById('<%=this.lblMessageError.ClientID %>').innerHTML = msg;
            myBehavior.show();

            if (reload == "true") {
                reloadPageAction = "true";
                pos = location.href.lastIndexOf('/') + 1;
                str = location.href.substring(0, pos);
                reloadPageActionURL = str + path;
            }
            else
                reloadPageAction = "false";
        }

        function CardNumberSaveAsToCardNumber() {
            window.document.getElementById('<%=this.txtCardNumber.ClientID %>').value = window.document.getElementById('<%=this.txtCardNumberSaveAs.ClientID %>').value
            window.document.getElementById('<%=this.txtCardNumber2.ClientID %>').value = "";
            window.document.getElementById('<%=this.txtCardNumber3.ClientID %>').value = "";
            window.document.getElementById('<%=this.txtCardNumber4.ClientID %>').value = "";
            window.document.getElementById('<%=this.txtCardNumber5.ClientID %>').value = "";
        }
    </script>
    <script language="javascript">
        var DisableddivAccessLevel = false;
        document.onreadystatechange = fnStartInit; function fnStartInit() { if (document.readyState == 'complete') checkSectionOpen(); }


        function checkSectionOpen() {

            var valueOfSection = window.document.getElementById('<%=this.sectionToOpen.ClientID %>').value;
            if (valueOfSection != "") {
                openSection(valueOfSection);
            }
            else {
                openSection("divCardNumber");
            }
        }

        function setExpired(obj) {
            if (obj.value == "EXPIRED") {

                //Fix regarding RDP #12691 Webstation - Selecting a card state of Expired will set the End Date for the next calendar day. 
                //made by JPMailhot
                //Date:
                //Comments: If expired, we don't put a expiration date  anymore                
            }
            if (obj.value == "VALID") {
                var today = new Date();
                today.format(window.document.getElementById('<%=this.formatDate.ClientID %>').value);
                var UsingEndDate = window.document.getElementById('<%=this.cboUsingEndDate.ClientID %>');
                var endDate = window.document.getElementById('<%=this.ajaxEndDate.ClientID %>');
                var StartDate = window.document.getElementById('<%=this.ajaxStartDate.ClientID %>');
                UsingEndDate.checked = false;
                endDate.value = "";

                if (StartDate.value == "" || StartDate.value == " ")
                    StartDate.value = today.format(window.document.getElementById('<%=this.formatDate.ClientID %>').value);
                else {
                    if (DateInDays(ConvertToDateFormat(StartDate.value)) > DateInDays(ConvertToDateFormat(today)))
                        StartDate.value = today.format(window.document.getElementById('<%=this.formatDate.ClientID %>').value);
                }
            }
            if (obj.value == "PENDING") {

                var today = new Date();
                today.format(window.document.getElementById('<%=this.formatDate.ClientID %>').value);
                var UsingEndDate = window.document.getElementById('<%=this.cboUsingEndDate.ClientID %>');
                var endDate = window.document.getElementById('<%=this.ajaxEndDate.ClientID %>');
                var StartDate = window.document.getElementById('<%=this.ajaxStartDate.ClientID %>');
                UsingEndDate.checked = false;
                endDate.value = "";
                today.setDate(today.getDate() + 1);
                StartDate.value = today.format(window.document.getElementById('<%=this.formatDate.ClientID %>').value);

                var myBehavior = $find("ModalPopupBehaviorSelectStartDate");                 
                myBehavior.show();

            }
        }

        function getPkdataAccessLevel(obj) {
            window.document.getElementById('<%=this.AccessLevelSecondarySelected.ClientID %>').value = obj.value;
            AddItemSelected(obj.value);
        }

        function getRowAccessLevelSecondary(obj) {
            window.document.getElementById('<%=this.RowForAccessLevelSecondarySelected.ClientID %>').value = obj.id;
        }

        function AddItemSelected(pkdata) {
            var myArray = new Array();
            var myBigArray = new Array();

            if (window.document.getElementById('<%=this.ReloadAccessLevelSelected.ClientID %>').value != "")
                myBigArray = window.document.getElementById('<%=this.ReloadAccessLevelSelected.ClientID %>').value.split(',');

            var index = window.document.getElementById('<%=this.RowForAccessLevelSecondarySelected.ClientID %>').value;
            var str = '[' + index + ';' + pkdata + ']';
            myBigArray[index] = str;

            window.document.getElementById('<%=this.ReloadAccessLevelSelected.ClientID %>').value = myBigArray;
            // statwords(myBigArray);
        }

        function statwords(message) {
            window.status = message;
        }

        function MessageResponseCreateNewCardOrReplace(answer) {
            window.document.getElementById('<%=this.ModifyAddCard_Answer.ClientID %>').value = answer;
        }

        function checkForReloadPage() {
            if (reloadPageAction == "true") {
                window.location = reloadPageActionURL;
            }
        }

        function ValidationAccessLevelSelected() {
            var cardAccessLevelSelected = window.document.getElementById('<%=this.ddlCardAccesGroup.ClientID %>');
            var divAccessLevel = window.document.getElementById('divRepeater');

            
            if (cardAccessLevelSelected.value > 1) {
                divAccessLevel.style.display = 'none';
                var curText = cardAccessLevelSelected.options[cardAccessLevelSelected.selectedIndex].text;
                window.document.getElementById('<%=this.ALTselected.ClientID %>').innerHTML = 'Access Level Template selected : ' + curText;
            }
            else {
                divAccessLevel.style.display = 'block';
                window.document.getElementById('<%=this.ALTselected.ClientID %>').innerHTML = '';
            }
        }

        function openSection(section) {
            window.document.getElementById('<%=this.sectionToOpen.ClientID %>').value = section;

            closeSection('divCardNumber');
            rolloutTab('divCardNumber');

            closeSection('divCardInfo');
            rolloutTab('divCardInfo');

            closeSection('divAccessLevel');
            rolloutTab('divAccessLevel');

            closeSection('divStartDateEndDate');
            rolloutTab('divStartDateEndDate');

            closeSection('divMiscellaneous');
            rolloutTab('divMiscellaneous');

            closeSection('divComment');
            rolloutTab('divComment');

            closeSection('divSignature');
            rolloutTab('divSignature');

            closeSection('divPicture');
            rolloutTab('divPicture');

//            closeSection('divTenant');
//            rolloutTab('divTenant');

            if (section == "divAccessLevel")
                ValidationAccessLevelSelected();

            window.document.getElementById(section).style.display = 'block';
            rolloverTab(section);
        }

        function closeSection(section) {
            window.document.getElementById(section).style.display = 'none';
        }

        function DisplayText(ddl, txt) {
            var oDDL = window.document.getElementById(ddl);
            window.document.getElementById(txt).value = oDDL.options[oDDL.selectedIndex].text;
            window.document.getElementById(txt).focus();
        }

//        function showHideTenantSection(chk) {
//            if (chk != null) {
//                if (chk.checked) {
//                    window.document.getElementById("divTenant_Container").style.display = 'block';
//                    window.document.getElementById("divTenant_Left").style.display = 'block';
//                    window.document.getElementById("divTenant_Right").style.display = 'block';
//                }
//                else {
//                    window.document.getElementById("divTenant_Container").style.display = 'none';
//                    window.document.getElementById("divTenant_Left").style.display = 'none';
//                    window.document.getElementById("divTenant_Right").style.display = 'none';
//                }
//            }
//        }


    </script>
    <div id="EditCardHeader">
        <div id="EditCardPicture">
            <div id="image">
                <img id="ImageUser" width="100" visible="true" src="../Common/Images/photo.jpg" height="100"
                    runat="server" style="display:block;margin:0 auto;text-align:center;" />
                <img id="defaultPicture" width="100" height="100" visible="false" src="../Common/Images/photo.jpg"
                    runat="server" style="display:block;margin:0 auto;text-align:center;" />
            </div>
        </div>
        <div id="EditCardDesc">
            <table style="width: 606px">
                <tr>
                    <td>
                        <asp:Label ID="lblUserName" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelUserName %>"></asp:Label>
                    </td>
                    <td>
                        <asp:TextBox ID="txtUserName" onkeyup="AskQuestion(this)" runat="server" TabIndex="1"
                            CssClass="txtEditCardDesc" Width="250px" MaxLength="50"></asp:TextBox>
                    </td>
<%--                    <td align="left">
                        <asp:CheckBox ID="chkIsTenant" runat="server" Visible="True" Text="Is Tenant" onclick="showHideTenantSection(this);" />
                    </td> --%>
                </tr>
                <tr>
                    <td align="left">
                        <asp:Label ID="lblCardState" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelCardState %>"></asp:Label>
                    </td>
                    <td>
                        <asp:DropDownList ID="ddlCardState" Width="254px" onChange="javascript:setExpired(this);"
                            runat="server" TabIndex="3" CssClass="txtEditCardDesc">
                            <asp:ListItem Text="VALID" Value="0"></asp:ListItem>
                            <asp:ListItem Text="INVALID" Value="1"></asp:ListItem>
                            <asp:ListItem Text="STOLEN\LOST" Value="2"></asp:ListItem>
                            <asp:ListItem Text="PENDING" Value="3"></asp:ListItem>
                            <asp:ListItem Text="EXPIRED" Value="4"></asp:ListItem>
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td align="left">
                        <asp:Label ID="lblCardType" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelCardType %>"></asp:Label>
                    </td>
                    <td align="left">
                        <asp:DropDownList ID="ddlCardType" Width="254px" runat="server" TabIndex="4" CssClass="txtEditCardDesc">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td align="left">
                        <asp:Label ID="lblCardFilter" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelCardFilter %>"></asp:Label>
                    </td>
                    <td align="left">
                        <asp:DropDownList ID="ddlCardFilter" Width="254px" runat="server" TabIndex="5" CssClass="txtEditCardDesc">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td align="left">
                        <asp:Label ID="lblBadging" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelBadgeLayout %>"></asp:Label>
                    </td>
                    <td>
                        <asp:DropDownList ID="ddlBadging" Width="254px" runat="server" TabIndex="6" CssClass="txtEditCardDesc">
                        </asp:DropDownList>

                    </td>
                    <td align="left">
                        <asp:CheckBox ID="chkBadgeRequest" runat="server" Visible="false" Text="<%$ Resources:AppResource, chkBadgeRequest %>" />
                        <asp:CheckBox ID="chkBadgeActivate" runat="server" Visible="false" Text="<%$ Resources:AppResource, chkActivateBadge %>" />
                    </td>                
                </tr>
                <tr>
                    <td align="left">
                        <asp:Label ID="lblCardAccessLevelTemp" runat="server" CssClass="lblEditCardDesc"
                            Text="<%$ Resources:AppResource, labelAccessLevelTemplate %>"></asp:Label>
                    </td>
                    <td>
                        <asp:DropDownList ID="ddlCardAccesGroup" onChange="javascript:ValidationAccessLevelSelected();"
                            Width="254px" runat="server" TabIndex="7" CssClass="txtEditCardDesc">
                        </asp:DropDownList>
                    </td>
                </tr>
            </table>
            <br/>
        </div>
    </div>

    <div id="divTabStrip">
        <ul>
            <li>&nbsp&nbsp&nbsp</li>
            <li class="LeftImg_off" id="divCardNumber_Left"></li>
            <li class="ContainerImg_off" id="divCardNumber_Container" onclick="javascript:openSection('divCardNumber');"
                onmouseout="javascript:rolloutTab('divCardNumber');" onmouseover="javascript:rolloverTab('divCardNumber');">
                <p>
                    <asp:Label ID="Label7" runat="server" CssClass="lblAction" Text="<%$ Resources:AppResource, divCardNumber_Tab %>"> </asp:Label></p>
            </li>
            <li class="RightImg_off" id="divCardNumber_Right"></li>
            <li class="LeftImg_off" id="divCardInfo_Left"></li>
            <li class="ContainerImg_off" id="divCardInfo_Container" onclick="javascript:openSection('divCardInfo');"
                onmouseout="javascript:rolloutTab('divCardInfo');" onmouseover="javascript:rolloverTab('divCardInfo');">
                <p>
                    <asp:Label ID="Label8" runat="server" CssClass="lblAction" Text="<%$ Resources:AppResource, divCardInfo_Tab %>"> </asp:Label></p>
            </li>
            <li class="RightImg_off" id="divCardInfo_Right"></li>
            <li class="LeftImg_off" id="divAccessLevel_Left"></li>
            <li class="ContainerImg_off" id="divAccessLevel_Container" onclick="javascript:openSection('divAccessLevel');"
                onmouseout="javascript:rolloutTab('divAccessLevel');" onmouseover="javascript:rolloverTab('divAccessLevel');">
                <p>
                    <asp:Label ID="Label9" runat="server" CssClass="lblAction" Text="<%$ Resources:AppResource, divAccessLevel_Tab %>"> </asp:Label></p>
            </li>
            <li class="RightImg_off" id="divAccessLevel_Right"></li>
            <li class="LeftImg_off" id="divStartDateEndDate_Left"></li>
            <li class="ContainerImg_off" id="divStartDateEndDate_Container" onclick="javascript:openSection('divStartDateEndDate');"
                onmouseout="javascript:rolloutTab('divStartDateEndDate');" onmouseover="javascript:rolloverTab('divStartDateEndDate');">
                <p>
                    <asp:Label ID="Label10" runat="server" CssClass="lblAction" Text="<%$ Resources:AppResource, divStartDateEndDate_Tab %>"> </asp:Label></p>
            </li>
            <li class="RightImg_off" id="divStartDateEndDate_Right"></li>
            <li class="LeftImg_off" id="divMiscellaneous_Left"></li>
            <li class="ContainerImg_off" id="divMiscellaneous_Container" onclick="javascript:openSection('divMiscellaneous');"
                onmouseout="javascript:rolloutTab('divMiscellaneous');" onmouseover="javascript:rolloverTab('divMiscellaneous');">
                <p>
                    <asp:Label ID="Label11" runat="server" CssClass="lblAction" Text="<%$ Resources:AppResource, divMiscellaneous_Tab %>"> </asp:Label></p>
            </li>
            <li class="RightImg_off" id="divMiscellaneous_Right"></li>
            <li class="LeftImg_off" id="divComment_Left"></li>
            <li class="ContainerImg_off" id="divComment_Container" onclick="javascript:openSection('divComment');"
                onmouseout="javascript:rolloutTab('divComment');" onmouseover="javascript:rolloverTab('divComment');">
                <p>
                    <asp:Label ID="Label12" runat="server" CssClass="lblAction" Text="<%$ Resources:AppResource, divComment_Tab %>"> </asp:Label></p>
            </li>
            <li class="RightImg_off" id="divComment_Right"></li>

            <li class="LeftImg_off" id="divPicture_Left"></li>
            <li class="ContainerImg_off" id="divPicture_Container" onclick="javascript:openSection('divPicture');"
                onmouseout="javascript:rolloutTab('divPicture');" onmouseover="javascript:rolloverTab('divPicture');">
                <p>
                    <asp:Label ID="Label20" runat="server" CssClass="lblAction" Text="<%$ Resources:AppResource, divPicture_Tab %>"> </asp:Label></p>
            </li>
            <li class="RightImg_off" id="divPicture_Right"></li>

            <li class="LeftImg_off" id="divSignature_Left"></li>
            <li class="ContainerImg_off" id="divSignature_Container" onclick="javascript:openSection('divSignature');"
                onmouseout="javascript:rolloutTab('divSignature');" onmouseover="javascript:rolloverTab('divSignature');">
                <p>
                    <asp:Label ID="Label19" runat="server" CssClass="lblAction" Text="<%$ Resources:AppResource, divSignature_Tab %>"> </asp:Label></p>
            </li>
            <li class="RightImg_off" id="divSignature_Right"></li>

<%--            <li class="LeftImg_off" id="divTenant_Left"></li>
            <li class="ContainerImg_off" id="divTenant_Container" onclick="javascript:openSection('divTenant');"
                onmouseout="javascript:rolloutTab('divTenant');" onmouseover="javascript:rolloverTab('divTenant');">
                <p>
                    <asp:Label ID="Label21" runat="server" CssClass="lblAction" Text="Tenant"> </asp:Label></p>
            </li>
            <li class="RightImg_off" id="divTenant_Right"></li>--%>
        </ul>
    </div>

    <div id="DivRadTabStrip">
        <div id="divCardNumber">
            <table class="tbltTabEditCard">
                <tr>
                    <td colspan="2" style="height: 40px">
                        <asp:Label ID="Label13" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelHeaderCardNumber %>"></asp:Label>
                    </td>
                    <td style="width: 103px; height: 40px">
                        <asp:Label ID="Label14" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelHeaderDisplayCardNumber %>"></asp:Label>
                    </td>
                    <td style="width: 85px; height: 40px">
                        <asp:Label ID="Label15" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelHeaderUseExpirationDate %>"></asp:Label>
                    </td>
                    <td style="width: 155px; height: 40px">
                        <asp:Label ID="Label16" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelHeaderExpirationDate %>"></asp:Label>
                    </td>
                    <td style="width: 46px; height: 40px">
                        <asp:Label ID="Label17" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelHeaderTrace %>"></asp:Label>
                    </td>
                    <td style="height: 40px">
                        <asp:Label ID="Label18" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelHeaderStolenLost %>"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="width: 120px">
                        <asp:Label ID="lblCardNumber" runat="server" CssClass="lblEditCardDesc"  ></asp:Label>
                    </td>
                    <td style="width: 101px">
                        <asp:TextBox ID="txtCardNumber" runat="server" CssClass="txtCardNumber" onkeyup="checkCardNumber(this)" 
                            TabIndex="2" MaxLength="20"></asp:TextBox>
                    </td>
                    <td style="width: 103px">
                        <asp:CheckBox ID="DisplayCardNumber1" Checked="True" Text="" CssClass="lblEditCardDesc"
                            TabIndex="19" runat="server" TextAlign="Left" />
                    </td>
                    <td style="width: 85px">
                        <asp:CheckBox ID="UsingEndDate1" Checked="false" OnClick="EnableOrDisableEndDate1(this)"
                            Text="" CssClass="lblEditCardDesc" TabIndex="19" runat="server" TextAlign="Left" />
                    </td>
                    <td style="width: 155px">
                        <asp:TextBox Width="76px" runat="server" ID="EndDate1" autocomplete="off" />
                        <asp:ImageButton ID="btnEndDate1" runat="server" ImageUrl="~/Common/Images/Cal.gif"
                            AlternateText="<%$ Resources:AppResource, calendarAtlTxt %>" />
                        <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderCard1" runat="server" TargetControlID="EndDate1"
                            MaskType="Date" />
                        <AjaxToolkit:CalendarExtender ID="CalendarExtenderCard1" runat="server" PopupButtonID="btnEndDate1"
                            TargetControlID="EndDate1" />
                    </td>
                    <td style="width: 46px">
                        <asp:CheckBox ID="Trace1" Checked="false" Text="" CssClass="lblEditCardDesc" TabIndex="19"
                            runat="server" TextAlign="Left" />
                    </td>
                    <td>
                        <asp:CheckBox ID="CardState1" Checked="false" Text="" CssClass="lblEditCardDesc"
                            TabIndex="19" runat="server" TextAlign="Left" />
                    </td>
                </tr>
                <tr>
                    <td style="width: 120px">
                        <asp:Label ID="lblCardNumber2" runat="server" CssClass="lblEditCardDesc"  ></asp:Label>
                    </td>
                    <td style="width: 101px">
                        <asp:TextBox ID="txtCardNumber2" runat="server" CssClass="txtCardNumber" onkeyup="checkCardNumber(this)"
                            TabIndex="2" MaxLength="20"></asp:TextBox>
                    </td>
                    <td style="width: 103px">
                        <asp:CheckBox ID="DisplayCardNumber2" Checked="True" Text="" CssClass="lblEditCardDesc"
                            TabIndex="19" runat="server" TextAlign="Left" />
                    </td>
                    <td style="width: 85px">
                        <asp:CheckBox ID="UsingEndDate2" Checked="false" OnClick="EnableOrDisableEndDate2(this)"
                            Text="" CssClass="lblEditCardDesc" TabIndex="19" runat="server" TextAlign="Left" />
                    </td>
                    <td style="width: 155px">
                        <asp:TextBox Width="76px" runat="server" ID="EndDate2" autocomplete="off" />
                        <asp:ImageButton ID="btnEndDate2" runat="server" ImageUrl="~/Common/Images/Cal.gif"
                            AlternateText="<%$ Resources:AppResource, calendarAtlTxt %>" />
                        <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderCard2" runat="server" TargetControlID="EndDate2"
                            MaskType="Date" />
                        <AjaxToolkit:CalendarExtender ID="CalendarExtenderCard2" runat="server" PopupButtonID="btnEndDate2"
                            TargetControlID="EndDate2" />
                    </td>
                    <td style="width: 46px">
                        <asp:CheckBox ID="Trace2" Checked="false" Text="" CssClass="lblEditCardDesc" TabIndex="19"
                            runat="server" TextAlign="Left" />
                    </td>
                    <td>
                        <asp:CheckBox ID="CardState2" Checked="false" Text="" CssClass="lblEditCardDesc"
                            TabIndex="19" runat="server" TextAlign="Left" />
                    </td>
                </tr>
                <tr>
                    <td style="width: 120px">
                        <asp:Label ID="lblCardNumber3" runat="server" CssClass="lblEditCardDesc"  ></asp:Label>
                    </td>
                    <td style="width: 101px">
                        <asp:TextBox ID="txtCardNumber3" runat="server" CssClass="txtCardNumber" onkeyup="checkCardNumber(this)"
                            TabIndex="2" MaxLength="20"></asp:TextBox>
                    </td>
                    <td style="width: 103px">
                        <asp:CheckBox ID="DisplayCardNumber3" Checked="True" Text="" CssClass="lblEditCardDesc"
                            TabIndex="19" runat="server" TextAlign="Left" />
                    </td>
                    <td style="width: 85px">
                        <asp:CheckBox ID="UsingEndDate3" OnClick="EnableOrDisableEndDate3(this)" Checked="false"
                            Text="" CssClass="lblEditCardDesc" TabIndex="19" runat="server" TextAlign="Left" />
                    </td>
                    <td style="width: 155px">
                        <asp:TextBox Width="76px" runat="server" ID="EndDate3" autocomplete="off" />
                        <asp:ImageButton ID="btnEndDate3" runat="server" ImageUrl="~/Common/Images/Cal.gif"
                            AlternateText="<%$ Resources:AppResource, calendarAtlTxt %>" />
                        <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderCard3" runat="server" TargetControlID="EndDate3"
                            MaskType="Date" />
                        <AjaxToolkit:CalendarExtender ID="CalendarExtenderCard3" runat="server" PopupButtonID="btnEndDate3"
                            TargetControlID="EndDate3" />
                    </td>
                    <td style="width: 46px">
                        <asp:CheckBox ID="Trace3" Checked="false" Text="" CssClass="lblEditCardDesc" TabIndex="19"
                            runat="server" TextAlign="Left" />
                    </td>
                    <td>
                        <asp:CheckBox ID="CardState3" Checked="false" Text="" CssClass="lblEditCardDesc"
                            TabIndex="19" runat="server" TextAlign="Left" />
                    </td>
                </tr>
                <tr>
                    <td style="width: 120px">
                        <asp:Label ID="lblCardNumber4" runat="server" CssClass="lblEditCardDesc"  ></asp:Label>
                    </td>
                    <td style="width: 101px">
                        <asp:TextBox ID="txtCardNumber4" runat="server" CssClass="txtCardNumber" onkeyup="checkCardNumber(this)"
                            TabIndex="2" MaxLength="20"></asp:TextBox>
                    </td>
                    <td style="width: 103px">
                        <asp:CheckBox ID="DisplayCardNumber4" Checked="True" Text="" CssClass="lblEditCardDesc"
                            TabIndex="19" runat="server" TextAlign="Left" />
                    </td>
                    <td style="width: 85px">
                        <asp:CheckBox ID="UsingEndDate4" OnClick="EnableOrDisableEndDate4(this)" Checked="false"
                            Text="" CssClass="lblEditCardDesc" TabIndex="19" runat="server" TextAlign="Left" />
                    </td>
                    <td style="width: 155px">
                        <asp:TextBox Width="76px" runat="server" ID="EndDate4" autocomplete="off" />
                        <asp:ImageButton ID="btnEndDate4" runat="server" ImageUrl="~/Common/Images/Cal.gif"
                            AlternateText="<%$ Resources:AppResource, calendarAtlTxt %>" />
                        <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderCard4" runat="server" TargetControlID="EndDate4"
                            MaskType="Date" />
                        <AjaxToolkit:CalendarExtender ID="CalendarExtenderCard4" runat="server" PopupButtonID="btnEndDate4"
                            TargetControlID="EndDate4" />
                    </td>
                    <td style="width: 46px">
                        <asp:CheckBox ID="Trace4" Checked="false" Text="" CssClass="lblEditCardDesc" TabIndex="19"
                            runat="server" TextAlign="Left" />
                    </td>
                    <td>
                        <asp:CheckBox ID="CardState4" Checked="false" Text="" CssClass="lblEditCardDesc"
                            TabIndex="19" runat="server" TextAlign="Left" />
                    </td>
                </tr>
                <tr>
                    <td style="width: 120px">
                        <asp:Label ID="lblCardNumber5" runat="server" CssClass="lblEditCardDesc"  ></asp:Label>
                    </td>
                    <td style="width: 101px">
                        <asp:TextBox ID="txtCardNumber5" runat="server" CssClass="txtCardNumber" onkeyup="checkCardNumber(this)"
                            TabIndex="2" MaxLength="20"></asp:TextBox>
                    </td>
                    <td style="width: 103px">
                        <asp:CheckBox ID="DisplayCardNumber5" Checked="True" Text="" CssClass="lblEditCardDesc"
                            TabIndex="19" runat="server" TextAlign="Left" />
                    </td>
                    <td style="width: 85px">
                        <asp:CheckBox ID="UsingEndDate5" OnClick="EnableOrDisableEndDate5(this)" Checked="false"
                            Text="" CssClass="lblEditCardDesc" TabIndex="19" runat="server" TextAlign="Left" />
                    </td>
                    <td style="width: 155px">
                        <asp:TextBox Width="76px" runat="server" ID="EndDate5" autocomplete="off" />
                        <asp:ImageButton ID="btnEndDate5" runat="server" ImageUrl="~/Common/Images/Cal.gif"
                            AlternateText="<%$ Resources:AppResource, calendarAtlTxt %>" />
                        <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderCard5" runat="server" TargetControlID="EndDate5"
                            MaskType="Date" />
                        <AjaxToolkit:CalendarExtender ID="CalendarExtenderCard5" runat="server" PopupButtonID="btnEndDate5"
                            TargetControlID="EndDate5" />
                    </td>
                    <td style="width: 46px">
                        <asp:CheckBox ID="Trace5" Checked="false" Text="" CssClass="lblEditCardDesc" TabIndex="19"
                            runat="server" TextAlign="Left" />
                    </td>
                    <td>
                        <asp:CheckBox ID="CardState5" Checked="false" Text="" CssClass="lblEditCardDesc"
                            TabIndex="19" runat="server" TextAlign="Left" />
                    </td>
                </tr>
            </table>
        </div>

        <div id="divCardInfo">
            <table class="tbltTabEditCard">
<%--                <tr>
                    <td>
                    </td>
                    <td>
                        <div runat="server" id="divInviteForIE6" style="float: left">
                            <asp:Label ID="lblInviteForIE6_1" Text="<%$ Resources:AppResource, InviteForIE6_1 %>"
                                CssClass="lblInviteForIE6" runat="server" Width="188px"> </asp:Label>
                            <asp:Label ID="lblInviteForIE6_2" Text="<%$ Resources:AppResource, InviteForIE6_2 %>"
                                CssClass="lblInviteForIE6" runat="server" Width="185px"> </asp:Label>
                        </div>
                    </td>
                </tr>--%>
                <tr id="trCardInfo1" style="display: inline">
                    <td class="lblTableCardInfo">
                        <asp:Label ID="lblCardInfo1" runat="server" CssClass="lblEditCardDesc"></asp:Label>
                    </td>
                    <td class="txtTableCardInfo">
                        <asp:TextBox ID="txtCardInfo1" runat="server" TabIndex="7" CssClass="txtCardInfo1_10"
                            MaxLength="50"></asp:TextBox>
                        <asp:DropDownList ID="ddlCardInfo1" CssClass="ddlCardInfo1_10" runat="server">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr id="trCardInfo2" style="display: inline">
                    <td class="lblTableCardInfo">
                        <asp:Label ID="lblCardInfo2" runat="server" CssClass="lblEditCardDesc"></asp:Label>
                    </td>
                    <td class="txtTableCardInfo">
                        <asp:TextBox ID="txtCardInfo2" runat="server" TabIndex="8" CssClass="txtCardInfo1_10"
                            MaxLength="50"></asp:TextBox>
                        <asp:DropDownList ID="ddlCardInfo2" CssClass="ddlCardInfo1_10" runat="server">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr id="trCardInfo3" style="display: inline">
                    <td class="lblTableCardInfo">
                        <asp:Label ID="lblCardInfo3" runat="server" CssClass="lblEditCardDesc"></asp:Label>
                    </td>
                    <td class="txtTableCardInfo">
                        <asp:TextBox ID="txtCardInfo3" runat="server" TabIndex="9" CssClass="txtCardInfo1_10"
                            MaxLength="50"></asp:TextBox>
                        <asp:DropDownList ID="ddlCardInfo3" CssClass="ddlCardInfo1_10" runat="server">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr id="trCardInfo4" style="display: inline">
                    <td class="lblTableCardInfo">
                        <asp:Label ID="lblCardInfo4" runat="server" CssClass="lblEditCardDesc"></asp:Label>
                    </td>
                    <td class="txtTableCardInfo">
                        <asp:TextBox ID="txtCardInfo4" runat="server" TabIndex="10" CssClass="txtCardInfo1_10"
                            MaxLength="50"></asp:TextBox>
                        <asp:DropDownList ID="ddlCardInfo4" CssClass="ddlCardInfo1_10" runat="server">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr id="trCardInfo5" style="display: inline">
                    <td class="lblTableCardInfo">
                        <asp:Label ID="lblCardInfo5" runat="server" CssClass="lblEditCardDesc"></asp:Label>
                    </td>
                    <td class="txtTableCardInfo">
                        <asp:TextBox ID="txtCardInfo5" runat="server" TabIndex="11" CssClass="txtCardInfo1_10"
                            MaxLength="50"></asp:TextBox>
                        <asp:DropDownList ID="ddlCardInfo5" CssClass="ddlCardInfo1_10" runat="server">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr id="trCardInfo6" style="display: inline">
                    <td class="lblTableCardInfo">
                        <asp:Label ID="lblCardInfo6" runat="server" CssClass="lblEditCardDesc"></asp:Label>
                    </td>
                    <td class="txtTableCardInfo">
                        <asp:TextBox ID="txtCardInfo6" runat="server" TabIndex="12" CssClass="txtCardInfo1_10"
                            MaxLength="50"></asp:TextBox>
                        <asp:DropDownList ID="ddlCardInfo6" CssClass="ddlCardInfo1_10" runat="server">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr id="trCardInfo7" style="display: inline">
                    <td class="lblTableCardInfo">
                        <asp:Label ID="lblCardInfo7" runat="server" CssClass="lblEditCardDesc"></asp:Label>
                    </td>
                    <td class="txtTableCardInfo">
                        <asp:TextBox ID="txtCardInfo7" runat="server" TabIndex="13" CssClass="txtCardInfo1_10"
                            MaxLength="50"></asp:TextBox>
                        <asp:DropDownList ID="ddlCardInfo7" CssClass="ddlCardInfo1_10" runat="server">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr id="trCardInfo8" style="display: inline">
                    <td class="lblTableCardInfo">
                        <asp:Label ID="lblCardInfo8" runat="server" CssClass="lblEditCardDesc"></asp:Label>
                    </td>
                    <td class="txtTableCardInfo">
                        <asp:TextBox ID="txtCardInfo8" runat="server" TabIndex="14" CssClass="txtCardInfo1_10"
                            MaxLength="50"></asp:TextBox>
                        <asp:DropDownList ID="ddlCardInfo8" CssClass="ddlCardInfo1_10" runat="server">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr id="trCardInfo9" style="display: inline">
                    <td class="lblTableCardInfo">
                        <asp:Label ID="lblCardInfo9" runat="server" CssClass="lblEditCardDesc"></asp:Label>
                    </td>
                    <td class="txtTableCardInfo">
                        <asp:TextBox ID="txtCardInfo9" runat="server" TabIndex="15" CssClass="txtCardInfo1_10"
                            MaxLength="50"></asp:TextBox>
                        <asp:DropDownList ID="ddlCardInfo9" CssClass="ddlCardInfo1_10" runat="server">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr id="trCardInfo10" style="display: inline">
                    <td class="lblTableCardInfo">
                        <asp:Label ID="lblCardInfo10" runat="server" CssClass="lblEditCardDesc"></asp:Label>
                    </td>
                    <td class="txtTableCardInfo">
                        <asp:TextBox ID="txtCardInfo10" runat="server" TabIndex="16" CssClass="txtCardInfo1_10"
                            MaxLength="50"></asp:TextBox>
                        <asp:DropDownList ID="ddlCardInfo10" CssClass="ddlCardInfo1_10" runat="server">
                        </asp:DropDownList>
                    </td>
                </tr>
            </table>
        </div>

        <div id="divStartDateEndDate">
            <div id="StartDateEndDate">
                <table cellpadding="8px" cellspacing="10px" class="tbltTabEditCard">
                    <tr>
                        <td class="lbl">
                            <asp:Label ID="lblStartDate" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelStartDate %>"></asp:Label>
                        </td>
                        <td class="txt">
                            <asp:TextBox Width="76px" runat="server" onchange="javascript:CalValStartDate(this);"
                                onfocus="javascript:CalValStartDate(this);" onblur="javascript:CalValStartDate(this);"
                                ID="ajaxStartDate" autocomplete="off" />
                            <asp:ImageButton ID="btnImageStartDate" runat="server" ImageUrl="~/Common/Images/Cal.gif"
                                AlternateText="<%$ Resources:AppResource, calendarAtlTxt %>" />
                            <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderStartDate" runat="server" TargetControlID="ajaxStartDate"
                                MaskType="Date" />
                            <AjaxToolkit:CalendarExtender ID="CalendarExtenderStartDate" runat="server" PopupButtonID="btnImageStartDate"
                                TargetControlID="ajaxStartDate" />
                        </td>
                    </tr>
                    <tr>
                        <td class="lbl">
                            <asp:Label ID="lblUsingEndDate" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelUsingEndDate %>"></asp:Label>
                        </td>
                        <td class="txt">
                            <asp:CheckBox ID="cboUsingEndDate" Checked="false" OnClick="EnableOrDisableEndDate(this)"
                                Text="" CssClass="lblEditCardDesc" TabIndex="19" runat="server" TextAlign="Left" />
                        </td>
                    </tr>
                    <tr>
                        <td class="lbl">
                            <asp:Label ID="Label1" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelEndDate %>"></asp:Label>
                        </td>
                        <td class="txt">
                            <asp:TextBox Width="76px" runat="server" onchange="javascript:CalValEndDate(this);"
                                onblur="javascript:CalValEndDate(this);" ID="ajaxEndDate" autocomplete="off" />
                            <asp:ImageButton ID="btnImageEndDate" runat="server" ImageUrl="~/Common/Images/Cal.gif"
                                AlternateText="<%$ Resources:AppResource, calendarAtlTxt %>" />
                            <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderEndDate" runat="server" TargetControlID="ajaxEndDate"
                                MaskType="Date" />
                            <AjaxToolkit:CalendarExtender ID="CalendarExtenderEndDate" runat="server" PopupButtonID="btnImageEndDate"
                                TargetControlID="ajaxEndDate" />
                        </td>
                    </tr>
                    <tr>
                        <td style="height: 30px" class="lbl">
                            <asp:Label ID="lblDeleteExpired" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelDeleteOnExpired %>"></asp:Label>
                        </td>
                        <td style="height: 30px" class="txt">
                            <asp:CheckBox ID="cboDeleteExpired" Checked="false" Text="" CssClass="lblEditCardDesc"
                                TabIndex="21" runat="server" TextAlign="Left" />
                        </td>
                    </tr>
                </table>
            </div>
        </div>

        <div id="divAccessLevel">
            <asp:Label ID="ALTselected" runat="server" Text=""> </asp:Label>
            <div id="divRepeater">
                <asp:GridView ID="myAccessGridView" CssClass="gridViewAccessLevel" runat="server"
                    AutoGenerateColumns="False" OnRowCommand="myAccessGridView_RowCommand" OnRowCreated="myAccessGridView_RowCreated">
                    <HeaderStyle CssClass="GridViewAccessLevelHeader" />
                    <RowStyle CssClass="GridViewAccessLevelRow" />
                    <AlternatingRowStyle CssClass="GridViewAccessLevelAlterRow" />
                    <Columns>
                        <asp:BoundField DataField="DESCRIPTION" HeaderText="<%$ Resources:AppResource, labelGatewaySiteHeader %>" />
                        <asp:TemplateField HeaderText="<%$ Resources:AppResource, labelAccessLevelHeader %>">
                            <ItemTemplate>
                                <div id='<%# Container.DataItemIndex %>'  onmousedown="javascript:getRowAccessLevelSecondary(this);"  >
                                    <asp:DropDownList Width="254px"   ID="ddlAccessLevel" onChange="getPkdataAccessLevel(this);"
                                        runat="server">
                                    </asp:DropDownList>
                                </div>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField ShowHeader="False">
                            <ItemTemplate>
                                <asp:ImageButton ID="imgViewSecondary" runat="server" CausesValidation="False" CommandName="ViewSecondary"
                                    ToolTip="<%$ Resources:AppResource, AlternateTextViewAccessLevelSecondary %>"
                                    ImageUrl="~/Common/Images/plus.jpg" CommandArgument='<%# Eval("PKDATA")%>' />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField ShowHeader="False">
                            <ItemTemplate>
                                <asp:ImageButton ID="imgViewShedule" runat="server" CausesValidation="False" CommandName="ViewShedule"
                                    ToolTip="<%$ Resources:AppResource, AlternateTextViewAccessLevelDetail %>" ImageUrl="~/Common/Images/loop.jpg"
                                    CommandArgument='<%# Container.DataItemIndex %>' />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>
            </div>
        </div>

        <div id="divMiscellaneous">
            <table cellpadding="8px" cellspacing="10px" class="tbltTabEditCard">
                <tr>
                    <td class="lbl">
                        <asp:Label ID="lblExtendedDelay" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelExtendedDelay %>"></asp:Label>
                    </td>
                    <td class="txt">
                        <asp:CheckBox ID="cboExtendedDelay" Checked="false" Text="" CssClass="lblEditCardDesc"
                            TabIndex="23" runat="server" TextAlign="Left" />
                    </td>
                </tr>
                <tr>
                    <td class="lbl">
                        <asp:Label ID="lblDisablePassback" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelDisablePassBack %>"></asp:Label>
                    </td>
                    <td class="txt">
                        <asp:CheckBox ID="cboDisablePassback" Checked="false" Text="" CssClass="lblEditCardDesc"
                            TabIndex="25" runat="server" TextAlign="Left" />
                    </td>
                </tr>
                <tr>
                    <td class="lbl">
                        <asp:Label ID="lblWaitForKeyPad" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelWaitForKeyPad %>"></asp:Label>
                    </td>
                    <td class="txt">
                        <asp:CheckBox ID="cboWaitForKeyPad" Checked="false" Text="" CssClass="lblEditCardDesc"
                            TabIndex="26" runat="server" TextAlign="Left" />
                    </td>
                </tr>
                <tr>
                    <td class="lbl">
                        <asp:Label ID="lblPinNumber" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelPinNumber %>"></asp:Label>
                    </td>
                    <td class="txt">
                        <asp:TextBox ID="txtPinNumber" runat="server" onkeyup="PinValidate(this)" onblur="javascript:insertZero();"
                            MaxLength="5" CssClass="txtEditCardDesc" TextMode="Password" Width="84px"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td class="lbl">
                        <asp:Label ID="lblPrivilegedOperation" runat="server" CssClass="lblEditCardDesc"
                            Text="<%$ Resources:AppResource, labelPrivilegedOperation %> "></asp:Label>
                    </td>
                    <td class="txt">
                        <asp:CheckBox ID="cboPrivilegedOperation" OnClick="EnableOrDisableSupervisorLevel(this)"
                            Checked="false" Text="" CssClass="lblEditCardDesc" TabIndex="26" runat="server"
                            TextAlign="Left" />
                    &nbsp;
                        <asp:Label ID="lblGlobalGatewayOnly" runat="server" 
                            Text="<%$ Resources:AppResource, GlobalGatewayOnlyLabel %>"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td class="lbl">
                        <asp:Label ID="lblSupervisorLevel" runat="server" CssClass="lblEditCardDesc" Text="<%$ Resources:AppResource, labelSupervisorLevel %>"></asp:Label>
                    </td>
                    <td class="txt">
                        <asp:DropDownList ID="ddlSupervisorLevel" Width="45px" runat="server" TabIndex="3"
                            CssClass="txtEditCardDesc">
                            <asp:ListItem Text="0" Value="0"></asp:ListItem>
                            <asp:ListItem Text="1" Value="1"></asp:ListItem>
                            <asp:ListItem Text="2" Value="2"></asp:ListItem>
                            <asp:ListItem Text="3" Value="3"></asp:ListItem>
                            <asp:ListItem Text="4" Value="4"></asp:ListItem>
                            <asp:ListItem Text="5" Value="5"></asp:ListItem>
                            <asp:ListItem Text="6" Value="6"></asp:ListItem>
                            <asp:ListItem Text="7" Value="7"></asp:ListItem>
                            <asp:ListItem Text="8" Value="8"></asp:ListItem>
                            <asp:ListItem Text="9" Value="9"></asp:ListItem>
                            <asp:ListItem Text="10" Value="10"></asp:ListItem>
                            <asp:ListItem Text="11" Value="11"></asp:ListItem>
                            <asp:ListItem Text="12" Value="12"></asp:ListItem>
                            <asp:ListItem Text="13" Value="13"></asp:ListItem>
                            <asp:ListItem Text="14" Value="14"></asp:ListItem>
                            <asp:ListItem Text="15" Value="15"></asp:ListItem>
                        </asp:DropDownList>
                    &nbsp;
                        <asp:Label ID="lblGlobalGatewayOnly2" runat="server" 
                            Text="<%$ Resources:AppResource, GlobalGatewayOnlyLabel %>"></asp:Label>
                    </td>
                </tr>
            </table>
        </div>

        <div id="divPicture">
            <table class="tbltTabEditCard" cellspacing="10px">
                
                <tr>
                    <td style="width: 365px; height: 20px; text-align: right">
                    <div id="divUploadFile">
                        <asp:Label ID="lblrealFile" runat="server" Text="<%$ Resources:AppResource, labelLoadingPicture %>"></asp:Label>&nbsp<input
                            type="file" id="realField" class="inputFile" runat="server" />
                    </div>
                        <div id="divDeleteBTN">
                            <asp:Button ID="btnDeletePicture" runat="server" Text="<%$ Resources:AppResource, deleteBTNtext %>"
                                Height="22px" OnClick="btnDeletePicture_Click" />
                        </div>
                    </td>
                    <td>
                    <div id="divPicCaptureButton">
                        <asp:ImageButton ID="btnOpenPicCapture" runat="server" ImageUrl="~/Common/Images/PictureCapture/Camera-Button.gif"
                            Height="28" Width="40" ToolTip="<%$ Resources:AppResource, labelOpenPicCapture %>"
                            OnClick="btnOpenPicCapture_Click" />
                    </div>
                </tr>
 
            </table>
        </div>

        <div id="divSignature">
            <table class="tbltTabEditCard" cellspacing="10px">
                <tr colspan="2">
                    <td>
                        <div id="EditCardSignature">
                            <div id="image">
                                <img id="ImageUserSignature" visible="true" src="../Common/Images/Signature.jpg"
                                    height="100" runat="server" />
                                <img id="defaultSignature" visible="false" src="../Common/Images/Signature.jpg" runat="server"
                                    height="100" />
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="width: 365px; height: 20px; text-align: right">
                        <div id="divUploadFileSignature">
                            <asp:Label ID="lblrealFileSignature" runat="server" Text="<%$ Resources:AppResource, labelLoadingSignature %>"></asp:Label>&nbsp<input
                                type="file" id="realFieldSignature" class="inputFile" runat="server" />
                        </div>
                        <div id="divDeleteBTNSignature">
                            <asp:Button ID="btnDeleteSignature" runat="server" Text="<%$ Resources:AppResource, deleteBTNSignature %>"
                                OnClick="btnDeleteSignature_Click" Height="22px" />
                        </div>
                    </td>
                    <td>
                        <div id="divSignaturePad">
                            <asp:ImageButton ID="btnOpenSignaturePad" runat="server" ImageUrl="~/Common/Images/SignaturePad/signaturepadbutton.gif"
                                Width="60px"   ToolTip="<%$ Resources:AppResource, labelSignaturePadButton %>"
                                OnClick="btnOpenSignaturePad_Click" />
                        </div>
                </tr>

                <tr>
                    <td>
                        <table>
                            <tr>
                                <td  style="width: auto">
                                    <asp:Label ID="Label25" runat="server" Text="Barcode:"></asp:Label>
                                </td>
                                <td>
                                    <asp:DropDownList runat="server" ID="ddlBarcodeFields">
                                        <asp:ListItem>Card #1</asp:ListItem>
                                        <asp:ListItem>Card #2</asp:ListItem>
                                        <asp:ListItem>Card #3</asp:ListItem>
                                        <asp:ListItem>Custom</asp:ListItem>
                                    </asp:DropDownList>
                                </td>
                            </tr>

                            <tr>
                                <td  style="width: auto">
                                    <asp:Label ID="Label26" runat="server" Text="Value:"></asp:Label>
                                </td>
                                <td>
                                    <asp:TextBox runat="server" ID="txtBarcodeFieldCustomValue"></asp:TextBox>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>

        <div id="divComment">
            <table class="tbltTabEditCard" width="100%">
                <tr>
                    <td>
                        <asp:TextBox ID="txtComment" onkeyup="checkMaxLength(this)" runat="server" Columns="90"
                            Rows="15" TabIndex="29" TextMode="MultiLine" CssClass="CommentTXT" MaxLength="240"></asp:TextBox>
                    </td>
                </tr>
            </table>
        </div>

<%--        <div id="divTenant">
            <table class="tbltTabEditCard" width="100%">
                <tr>
                    <td>
                        <asp:Label ID="Label22" runat="server" CssClass="lblAction" Text="Phone:"> </asp:Label>
                    </td>
                    <td>
                        <asp:TextBox runat="server" ID="txtTenantPhone"></asp:TextBox>
                    </td>
                </tr>

                <tr>
                    <td>
                        <asp:Label ID="Label23" runat="server" CssClass="lblAction" Text="Phone 2:"> </asp:Label>
                    </td>

                    <td>
                        <asp:TextBox runat="server" ID="txtTenantPhobne2"></asp:TextBox>
                    </td>
                </tr>

                <tr>
                    <td>
                        <asp:Label ID="Label24" runat="server" CssClass="lblAction" Text="PIN:"> </asp:Label>
                    </td>

                    <td>
                        <asp:TextBox runat="server" ID="txtTenantPIN"></asp:TextBox>
                    </td>
                </tr>
            </table>
        </div>--%>
        
        <div id="BadgCredentialState">
            <table class="tbltTabBadgeCredential"> 
                <tr>
                    <td align="left" width="100%">
                        <asp:TextBox ID="txtBadgeCredentialState" runat="server" Enabled="false" 
                            Width="748px"></asp:TextBox>
                    </td>
                </tr>
            </table>
        </div>


    </div>

    <div id="EditCardBTN">
       <table width="100%" class="tblEditCardBTN">
            <tr>
                <td align="left">
                    <asp:Button ID="btnSave" TabIndex="30" runat="server" Text="<%$ Resources:AppResource, btnSave %>"
                        OnClick="Save_Click" Height="22px" OnClientClick="return checkValidateAllField();" />
                    <asp:Button ID="btnSaveAs" TabIndex="31" runat="server" Text="<%$ Resources:AppResource, btnSaveAs %>"
                        Height="22px" OnClick="btnSaveAs_Click" OnClientClick="return checkValidateAllField();" />
                    <asp:Button ID="btnCancel" runat="server" Text="<%$ Resources:AppResource, btnCancel %>"
                        Height="22px" OnClick="btnCancel_Click1" />
                </td>             
            </tr>
          
        </table>
    </div>

    <div id="messagePanelEditCard">
        <AjaxToolkit:ConfirmButtonExtender ID="ConfirmButtonExtender2" runat="server" TargetControlID="btnSaveAs"
            DisplayModalPopupID="ModalPopupExtender1" />
        <br />
        <AjaxToolkit:ModalPopupExtender ID="ModalPopupExtender1" runat="server" TargetControlID="btnSaveAs"
            PopupControlID="PNL" OkControlID="ButtonOk" CancelControlID="ButtonCancel" BackgroundCssClass="modalBackground">
        </AjaxToolkit:ModalPopupExtender>
        <asp:Panel ID="PNL" runat="server" Style="display: none; padding: 20px" CssClass="modalMessage">
            <div style="text-align: left;">
                <asp:Label ID="Label2" runat="server" Text="<%$ Resources:AppResource, labelNewCardNumber %>"></asp:Label><br />
                <asp:TextBox ID="txtCardNumberSaveAs" onkeyup="checkCardNumber(this)" runat="server"
                    TabIndex="2" CssClass="txtEditCardDesc" Width="250px" MaxLength="20"></asp:TextBox>
            </div>
            <br />
            <div style="text-align: center;">
                <asp:Button ID="ButtonOk" Width="75px" Height="23px" runat="server" Text="<%$ Resources:AppResource, btnOK %>"
                    OnClientClick="javascript:CardNumberSaveAsToCardNumber();" />
                <asp:Button ID="ButtonCancel" Width="75px" Height="23px" runat="server" Text="<%$ Resources:AppResource, btnCancel %>" />
            </div>
        </asp:Panel>
    </div>
    <div id="messageOK">
        <asp:Button runat="server" ID="TargetControlForMessageOK" Style="display: none" />
        <AjaxToolkit:ModalPopupExtender runat="server" ID="ModalPopupMessageOK" BehaviorID="ModalPopupBehaviorMessageOK"
            TargetControlID="TargetControlForMessageOK" PopupControlID="PanelMessageOK" BackgroundCssClass="modalBackground"
            RepositionMode="RepositionOnWindowResizeAndScroll">
        </AjaxToolkit:ModalPopupExtender>
        <asp:Panel ID="PanelMessageOK" runat="server" Style="display: none; padding: 20px"
            CssClass="modalMessage">
            <div>
                <asp:Label runat="server" ID="lblMessageOK"></asp:Label><br />
                <br />
            </div>
            <div style="text-align: center;">
                <asp:Button ID="btnCloseMessageOK" Width="75px" Height="23px" runat="server" Text="<%$ Resources:AppResource, btnOK %>"
                    OnClick="HidePanelMessageOK_Click" />
            </div>
        </asp:Panel>
    </div>
    <div id="messageOkReload">
        <asp:Button runat="server" ID="TargetControlForMessageOkReload" Style="display: none" />
        <AjaxToolkit:ModalPopupExtender runat="server" ID="ModalPopupExtenderMessageOkReload"
            BehaviorID="ModalPopupBehaviorMessageOKReload" TargetControlID="TargetControlForMessageOKReload"
            PopupControlID="PanelMessageOKReload" BackgroundCssClass="modalBackground" RepositionMode="RepositionOnWindowResizeAndScroll">
        </AjaxToolkit:ModalPopupExtender>
        <asp:Panel ID="PanelMessageOKReload" runat="server" Style="display: none; padding: 20px"
            CssClass="modalMessage">
            <div>
                <asp:Label runat="server" ID="lblMessageOKReload"></asp:Label><br />
                <br />
            </div>
            <div style="text-align: center;">
                <asp:Button ID="btnMessageOkReload_Reload" Width="75px" Height="23px" runat="server"
                    Text="<%$ Resources:AppResource, labelYes %>" OnClick="ReloadForAddPage_Click" />
                <asp:Button ID="btnMessageOkReload_OK" Width="75px" Height="23px" runat="server"
                    Text="<%$ Resources:AppResource, labelNo %>" OnClick="MessageOkReloadOK_Click" />
                <asp:Button ID="Button3" Height="23px" runat="server" Text="<%$ Resources:AppResource, labelBackToList %>"
                    OnClick="BackToList_Click" />
            </div>
        </asp:Panel>
    </div>
    <div id="popupMessageYesNoJavascript">
        <asp:Button runat="server" ID="btnMessageYesNoJavascript" Style="display: none" />
        <AjaxToolkit:ModalPopupExtender runat="server" ID="ModalPopupExtender2" BehaviorID="ModalPopupBehaviorMessageYesNoJavascript"
            TargetControlID="btnMessageYesNoJavascript" PopupControlID="PanelMessageYesNoJavascript"
            BackgroundCssClass="modalBackground" RepositionMode="RepositionOnWindowResizeAndScroll">
        </AjaxToolkit:ModalPopupExtender>
        <asp:Panel ID="PanelMessageYesNoJavascript" runat="server" Style="display: none;
            padding: 20px" CssClass="modalMessage">
            <div>
                <asp:Label runat="server" ID="Label6" Text="<%$ Resources:AppResource, MessageCreateNewCard %>"></asp:Label><br />
                <br />
            </div>
            <div style="text-align: center;">
                <asp:Button ID="Button1" Width="75px" Height="23px" runat="server" Text="<%$ Resources:AppResource, labelYes %>"
                    OnClientClick="MessageResponseCreateNewCardOrReplace('Yes');" OnClick="resetAccessLevelBtn1_Click" />
                <asp:Button ID="Button2" Width="75px" Height="23px" runat="server" Text="<%$ Resources:AppResource, labelNo %>"
                    OnClientClick="MessageResponseCreateNewCardOrReplace('No'); " OnClick="resetAccessLevelBtn2_Click" />
            </div>
        </asp:Panel>
    </div>
    <div id="MessageError">
        <asp:Button runat="server" ID="btnMessageError" Style="display: none" />
        <AjaxToolkit:ModalPopupExtender runat="server" ID="ModalPopupExtenderMessageError"
            BehaviorID="ModalPopupBehaviorMessageError" TargetControlID="btnMessageError"
            PopupControlID="PanelMessageError" BackgroundCssClass="modalBackground" RepositionMode="RepositionOnWindowResizeAndScroll">
        </AjaxToolkit:ModalPopupExtender>
        <asp:Panel ID="PanelMessageError" runat="server" Style="display: none; padding: 20px"
            CssClass="modalMessage">
            <div>
                <asp:Label runat="server" ID="lblMessageError"></asp:Label><br />
                <br />
            </div>
            <div style="text-align: center;">
                <asp:Button ID="btnOKMessageError" Width="75px" Height="23px" runat="server" Text="<%$ Resources:AppResource, btnOK %>"
                    OnClientClick="checkForReloadPage(); " OnClick="btnOKMessageError_Click" />
            </div>
        </asp:Panel>
    </div>
    
    <div id="divSelectStartDate" style="margin-left:150px">
        <asp:Button runat="server" ID="btnSelectStartDate" Style="display: none" />
        <AjaxToolkit:ModalPopupExtender runat="server" ID="ModalPopupExtenderSelectStartDate" BehaviorID="ModalPopupBehaviorSelectStartDate"
            TargetControlID="btnSelectStartDate" PopupControlID="PanelSelectStartDate" BackgroundCssClass="modalBackground"
            RepositionMode="RepositionOnWindowResizeAndScroll">
        </AjaxToolkit:ModalPopupExtender>
        <asp:Panel ID="PanelSelectStartDate" runat="server" Style="display: none; padding: 20px;"
            CssClass="modalMessageSelectStartDate">
            <div style="text-align: left;">
                <asp:Label runat="server" ID="lblSelectStartDate" Text="<%$ Resources:AppResource, SelectStartDate %>"></asp:Label><br />
                <br />
                    <asp:TextBox Width="76px" runat="server" ID="txtSelectStartDate" autocomplete="off"   />
                   <asp:ImageButton ID="imgSelectStartDate" runat="server" ImageUrl="~/Common/Images/Cal.gif"
                            AlternateText="<%$ Resources:AppResource, calendarAtlTxt %>" />
                    <AjaxToolkit:MaskedEditExtender ID="masktxtSelectStartDateExtender" runat="server"
                        TargetControlID="txtSelectStartDate" MaskType="Date"/>
                    <AjaxToolkit:CalendarExtender ID="calendarExtenderSelectStartDate" runat="server" TargetControlID="txtSelectStartDate" PopupButtonID="imgSelectStartDate" />


              <%--  <telerik:RadDatePicker ID="datStartDate" runat="server" Width="100px" ZIndex="7100" >
                </telerik:RadDatePicker>--%>
                <br />
       
            </div>
 
            <div style="text-align: left;margin-top:50px">
                <asp:Button ID="btnOKSelectStartDate" Width="75px" Height="23px" runat="server" Text="<%$ Resources:AppResource, btnOK %>"
                    OnClick="HidePanelSelectStartDate_Click"  />
                <asp:Button ID="btnCancelSelectStartDate" Width="75px" Height="23px" runat="server" Text="<%$ Resources:AppResource, btnCancel %>"
                    OnClick="HidePanelCancelSelectStartDate_Click" />
            </div>
        </asp:Panel>
    </div>
</div>




<script language="javascript">
    checkSectionOpen();
</script>
<div id="popupSecondary">
    <asp:Button runat="server" ID="TargetControlForSecondary" Style="display: none" />
    <AjaxToolkit:ModalPopupExtender runat="server" ID="SecondaryModalPopup" BehaviorID="SecondaryModalPopupBehavior"
        TargetControlID="TargetControlForSecondary" PopupControlID="SecondaryPopup" BackgroundCssClass="modalBackground"
        RepositionMode="None">
    </AjaxToolkit:ModalPopupExtender>
    <asp:Panel runat="server" CssClass="modalPopup" ID="SecondaryPopup" Style="display: none;
        padding: 5px" Height="435px" Width="650px">
        <div id="divSecondaryPopup">
            <asp:Label CssClass="lblTitreSecondary" runat="server" ID="lblSecondaryAccessLevel"
                Width="645px"></asp:Label><hr>
            <table id="tblSecondaryAccessLevel" cellpadding="0" cellspacing="0" runat="server"
                class="tblSecondary">
                <tr class="trSecondaryBorderB">
                    <td>
                        <asp:Label CssClass="lblHeaderSecondary" runat="server" ID="Label3">Access Level</asp:Label>
                    </td>
                    <td class="TDSecondaryBorderLR">
                        <asp:Label CssClass="lblHeaderSecondary" runat="server" ID="Label4">Use Date</asp:Label>
                    </td>
                    <td>
                        <asp:Label CssClass="lblHeaderSecondary" runat="server" ID="Label5">Expiration Date</asp:Label>
                    </td>
                </tr>
                <tr class="trSecondary">
                    <td>
                        <asp:DropDownList Width="244px" ID="ddlAccessLevelSecondary1" runat="server">
                        </asp:DropDownList>
                    </td>
                    <td class="TDSecondaryBorderLR">
                        <asp:CheckBox ID="cboAccessLevelSecondary1" runat="server" />
                    </td>
                    <td>
                        <asp:TextBox Width="76px" runat="server" ID="DateSecondary1" autocomplete="off" ToolTip="<%$ Resources:AppResource, calendarAtlTxt %>" />
                        <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderExpirDate1" runat="server"
                            TargetControlID="DateSecondary1" MaskType="Date" />
                        <AjaxToolkit:CalendarExtender ID="CalendarDateSecondary1" runat="server" TargetControlID="DateSecondary1" />
                    </td>
                </tr>
                <tr class="trSecondary">
                    <td>
                        <asp:DropDownList Width="244px" ID="ddlAccessLevelSecondary2" runat="server">
                        </asp:DropDownList>
                    </td>
                    <td class="TDSecondaryBorderLR">
                        <asp:CheckBox ID="cboAccessLevelSecondary2" runat="server" />
                    </td>
                    <td>
                        <asp:TextBox Width="76px" runat="server" ID="DateSecondary2" autocomplete="off" ToolTip="<%$ Resources:AppResource, calendarAtlTxt %>" />
                        <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderExpirDate2" runat="server"
                            TargetControlID="DateSecondary2" MaskType="Date" />
                        <AjaxToolkit:CalendarExtender ID="CalendarDateSecondary2" runat="server" TargetControlID="DateSecondary2" />
                    </td>
                </tr>
                <tr class="trSecondary">
                    <td>
                        <asp:DropDownList Width="244px" ID="ddlAccessLevelSecondary3" runat="server">
                        </asp:DropDownList>
                    </td>
                    <td class="TDSecondaryBorderLR">
                        <asp:CheckBox ID="cboAccessLevelSecondary3" runat="server" />
                    </td>
                    <td>
                        <asp:TextBox Width="76px" runat="server" ID="DateSecondary3" autocomplete="off" ToolTip="<%$ Resources:AppResource, calendarAtlTxt %>" />
                        <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderExpirDate3" runat="server"
                            TargetControlID="DateSecondary3" MaskType="Date" />
                        <AjaxToolkit:CalendarExtender ID="CalendarDateSecondary3" runat="server" TargetControlID="DateSecondary3" />
                    </td>
                </tr>
                <tr class="trSecondary">
                    <td>
                        <asp:DropDownList Width="244px" ID="ddlAccessLevelSecondary4" runat="server">
                        </asp:DropDownList>
                    </td>
                    <td class="TDSecondaryBorderLR">
                        <asp:CheckBox ID="cboAccessLevelSecondary4" runat="server" />
                    </td>
                    <td>
                        <asp:TextBox Width="76px" runat="server" ID="DateSecondary4" autocomplete="off" ToolTip="<%$ Resources:AppResource, calendarAtlTxt %>" />
                        <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderExpirDate4" runat="server"
                            TargetControlID="DateSecondary4" Mask="99/99/9999" MaskType="Date" CultureName="en-US" />
                        <AjaxToolkit:CalendarExtender ID="CalendarDateSecondary4" runat="server" TargetControlID="DateSecondary4" />
                    </td>
                </tr>
                <tr class="trSecondary">
                    <td>
                        <asp:DropDownList Width="244px" ID="ddlAccessLevelSecondary5" runat="server">
                        </asp:DropDownList>
                    </td>
                    <td class="TDSecondaryBorderLR">
                        <asp:CheckBox ID="cboAccessLevelSecondary5" runat="server" />
                    </td>
                    <td>
                        <asp:TextBox Width="76px" runat="server" ID="DateSecondary5" autocomplete="off" ToolTip="<%$ Resources:AppResource, calendarAtlTxt %>" />
                        <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderExpirDate5" runat="server"
                            TargetControlID="DateSecondary5" MaskType="Date" />
                        <AjaxToolkit:CalendarExtender ID="CalendarDateSecondary5" runat="server" TargetControlID="DateSecondary5" />
                    </td>
                </tr>
                <tr class="trSecondary">
                    <td>
                        <asp:DropDownList Width="244px" ID="ddlAccessLevelSecondary6" runat="server">
                        </asp:DropDownList>
                    </td>
                    <td class="TDSecondaryBorderLR">
                        <asp:CheckBox ID="cboAccessLevelSecondary6" runat="server" />
                    </td>
                    <td>
                        <asp:TextBox Width="76px" runat="server" ID="DateSecondary6" autocomplete="off" ToolTip="<%$ Resources:AppResource, calendarAtlTxt %>" />
                        <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderExpirDate6" runat="server"
                            TargetControlID="DateSecondary6" MaskType="Date" />
                        <AjaxToolkit:CalendarExtender ID="CalendarDateSecondary6" runat="server" TargetControlID="DateSecondary6" />
                    </td>
                </tr>
                <tr class="trSecondary">
                    <td>
                        <asp:DropDownList Width="244px" ID="ddlAccessLevelSecondary7" runat="server">
                        </asp:DropDownList>
                    </td>
                    <td class="TDSecondaryBorderLR">
                        <asp:CheckBox ID="cboAccessLevelSecondary7" runat="server" />
                    </td>
                    <td>
                        <asp:TextBox Width="76px" runat="server" ID="DateSecondary7" autocomplete="off" ToolTip="<%$ Resources:AppResource, calendarAtlTxt %>" />
                        <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderExpirDate7" runat="server"
                            TargetControlID="DateSecondary7" MaskType="Date" />
                        <AjaxToolkit:CalendarExtender ID="CalendarDateSecondary7" runat="server" TargetControlID="DateSecondary7" />
                    </td>
                </tr>
                <tr class="trSecondary">
                    <td>
                        <asp:DropDownList Width="244px" ID="ddlAccessLevelSecondary8" runat="server">
                        </asp:DropDownList>
                    </td>
                    <td class="TDSecondaryBorderLR">
                        <asp:CheckBox ID="cboAccessLevelSecondary8" runat="server" />
                    </td>
                    <td>
                        <asp:TextBox Width="76px" runat="server" ID="DateSecondary8" autocomplete="off" ToolTip="<%$ Resources:AppResource, calendarAtlTxt %>" />
                        <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderExpirDate8" runat="server"
                            TargetControlID="DateSecondary8" MaskType="Date" />
                        <AjaxToolkit:CalendarExtender ID="CalendarDateSecondary8" runat="server" TargetControlID="DateSecondary8" />
                    </td>
                </tr>
                <tr class="trSecondary">
                    <td>
                        <asp:DropDownList Width="244px" ID="ddlAccessLevelSecondary9" runat="server">
                        </asp:DropDownList>
                    </td>
                    <td class="TDSecondaryBorderLR">
                        <asp:CheckBox ID="cboAccessLevelSecondary9" runat="server" />
                    </td>
                    <td>
                        <asp:TextBox Width="76px" runat="server" ID="DateSecondary9" autocomplete="off" ToolTip="<%$ Resources:AppResource, calendarAtlTxt %>" />
                        <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderExpirDate9" runat="server"
                            TargetControlID="DateSecondary9" MaskType="Date" />
                        <AjaxToolkit:CalendarExtender ID="CalendarDateSecondary9" runat="server" TargetControlID="DateSecondary9" />
                    </td>
                </tr>
                <tr class="trSecondary">
                    <td>
                        <asp:DropDownList Width="244px" ID="ddlAccessLevelSecondary10" runat="server">
                        </asp:DropDownList>
                    </td>
                    <td class="TDSecondaryBorderLR">
                        <asp:CheckBox ID="cboAccessLevelSecondary10" runat="server" />
                    </td>
                    <td>
                        <asp:TextBox Width="76px" runat="server" ID="DateSecondary10" autocomplete="off"
                            ToolTip="<%$ Resources:AppResource, calendarAtlTxt %>" />
                        <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderExpirDate10" runat="server"
                            TargetControlID="DateSecondary10" MaskType="Date" />
                        <AjaxToolkit:CalendarExtender ID="CalendarDateSecondary10" runat="server" TargetControlID="DateSecondary10" />
                    </td>
                </tr>
                <tr class="trSecondary">
                    <td>
                        <asp:DropDownList Width="244px" ID="ddlAccessLevelSecondary11" runat="server">
                        </asp:DropDownList>
                    </td>
                    <td class="TDSecondaryBorderLR">
                        <asp:CheckBox ID="cboAccessLevelSecondary11" runat="server" />
                    </td>
                    <td>
                        <asp:TextBox Width="76px" runat="server" ID="DateSecondary11" autocomplete="off"
                            ToolTip="<%$ Resources:AppResource, calendarAtlTxt %>" />
                        <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderExpirDate11" runat="server"
                            TargetControlID="DateSecondary11" MaskType="Date" />
                        <AjaxToolkit:CalendarExtender ID="CalendarDateSecondary11" runat="server" TargetControlID="DateSecondary11" />
                    </td>
                </tr>
                <tr class="trSecondary">
                    <td>
                        <asp:DropDownList Width="244px" ID="ddlAccessLevelSecondary12" runat="server">
                        </asp:DropDownList>
                    </td>
                    <td class="TDSecondaryBorderLR">
                        <asp:CheckBox ID="cboAccessLevelSecondary12" runat="server" />
                    </td>
                    <td>
                        <asp:TextBox Width="76px" runat="server" ID="DateSecondary12" autocomplete="off"
                            ToolTip="<%$ Resources:AppResource, calendarAtlTxt %>" />
                        <AjaxToolkit:MaskedEditExtender ID="MaskedEditExtenderExpirDate12" runat="server"
                            TargetControlID="DateSecondary12" MaskType="Date" />
                        <AjaxToolkit:CalendarExtender ID="CalendarDateSecondary12" runat="server" TargetControlID="DateSecondary12" />
                    </td>
                </tr>
            </table>
            <br>
        </div>
        <div style="text-align: right;">
            <asp:Button ID="btnSaveSecondary" runat="server" Text="<%$ Resources:AppResource, btnSave %>"
                OnClick="SavePopupSecondary_Click" />
            <asp:Button ID="btnCancelSecondary" runat="server" Text="<%$ Resources:AppResource, btnCancel %>"
                OnClick="HidePopupSecondary_Click" />
        </div>
        <br />
    </asp:Panel>
</div>
<div id="popupShedule">
    <asp:Button runat="server" ID="TargetControlForSchedule" Style="display: none" />
    <AjaxToolkit:ModalPopupExtender runat="server" ID="SheduleModalPopup" BehaviorID="SheduleModalPopupBehavior"
        TargetControlID="TargetControlForSchedule" PopupControlID="ShedulePopup" BackgroundCssClass="modalBackground"
        RepositionMode="RepositionOnWindowResizeAndScroll">
    </AjaxToolkit:ModalPopupExtender>
    <asp:Panel runat="server" CssClass="modalPopup" ID="ShedulePopup" Style="display: none;
        padding: 5px" Height="350px" Width="930px">
        <asp:Label CssClass="lblTitreSecondary" runat="server" ID="lblGatewaySchedule" Width="925px"></asp:Label><br />
        <asp:Label CssClass="lblTitreSecondary" runat="server" ID="lblAcessLevelSchedule"
            Width="925px"></asp:Label><hr>
        <br />
        <div id="grdSchedule">
            <asp:GridView ID="GridViewSchedule" CssClass="tblSecondary" Width="920px" runat="server"
                AutoGenerateColumns="False">
                <HeaderStyle CssClass="SheduleRepeaterSecondaryBorderB" />
                <RowStyle CssClass="GridViewAccessLevelRow" />
                <AlternatingRowStyle CssClass="GridViewAccessLevelAlterRow" />
                <Columns>
                    <asp:BoundField ItemStyle-CssClass="TDSecondaryBorderLR" ControlStyle-CssClass="lblHeaderSecondary"
                        DataField="DOOR" HeaderText="<%$ Resources:AppResource, labelDoor %>" />
                </Columns>
                <Columns>
                    <asp:BoundField ItemStyle-CssClass="TDSecondaryBorderLR" ControlStyle-CssClass="lblHeaderSecondary"
                        DataField="SCHEDULE" HeaderText="<%$ Resources:AppResource, labelSchedule %>" />
                </Columns>
                <Columns>
                    <asp:BoundField ItemStyle-CssClass="TDSecondaryBorderLR" ControlStyle-CssClass="lblHeaderSecondary"
                        DataField="FLOORGROUP" HeaderText="<%$ Resources:AppResource, labelFloorGroup %>" />
                </Columns>
            </asp:GridView>
        </div>
        <div style="text-align: right;">
            <asp:Button ID="btnCloseSchedule" runat="server" Text="<%$ Resources:AppResource, btnClose %>"
                OnClick="HidePopupShedule_Click" />
        </div>
        <br />
    </asp:Panel>
</div>
<script language="Javascript">

    function SetupSignaturePad() {


        try {
               document.getElementById("SigPlus1").TabletState = 1;
               document.getElementById("SigPlus1").DisplayPenWidth=<%= SignaturePadPenWidth %>;
               document.getElementById("SigPlus1").ImagePenWidth=<%= SignaturePadPenWidth %> ;            
               document.getElementById("SigPlus1").SetEnableColor(1);
               document.getElementById("SigPlus1").BackColor = 14722174;
            }
            catch (err) {
            }
    }
    
 
 
 
</script>
