﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="AccessLevelGraphicView.ascx.cs"
    Inherits="WebStation.AccessLevels.AccessLevelGraphicView" %>

<script src="../Common/JavaScript/prototype.js" type="text/javascript"></script>
<script type="text/javascript">


    //Catch Silverlight Error 
    //and force a post back in order to throw it to asp.net
    function onSilverlightError(sender, args) {

        //There seems to be a problem with the Silverlight plugin and Firefox. By disabling this error check, it works.
        if (Prototype.Browser.Gecko)
            return;

        var appSource = "";
        if (sender != null && sender != 0) {
            appSource = sender.getHost().Source;

        }


        var errorType = args.ErrorType;
        var iErrorCode = args.ErrorCode;

        if (errorType == "ImageError" || errorType == "MediaError") {
            return;
        }

        var errMsg = "Unhandled Error in Silverlight Application " + appSource + "\n";

        errMsg += "Code: " + iErrorCode + "    \n";
        errMsg += "Category: " + errorType + "       \n";
        errMsg += "Message: " + args.ErrorMessage + "     \n";

        if (errorType == "ParserError") {
            errMsg += "File: " + args.xamlFile + "     \n";
            errMsg += "Line: " + args.lineNumber + "     \n";
            errMsg += "Position: " + args.charPosition + "     \n";
        }
        else if (errorType == "RuntimeError") {
            if (args.lineNumber != 0) {
                errMsg += "Line: " + args.lineNumber + "     \n";
                errMsg += "Position: " + args.charPosition + "     \n";
            }
            errMsg += "MethodName: " + args.methodName + "     \n";
        }

        window.document.getElementById('<%=this.SilverlightError.ClientID %>').value = errMsg.escapeHTML();
 
        __doPostBack('', '');


    }





    /*SILVERLIGHT METHODS*/
    var silverlightControl = null;



    //Cancel Modification
    function BindData(accessLevelID, gatewaySiteID) {
        try
        {
            if (silverlightControl != null)
                silverlightControl.Content.Page.BindData(accessLevelID, gatewaySiteID);
 
        }
        catch(err)
        {}


    }


    //ShowOnlyDoor
    function ShowOnlyDoor(showOnlyDoor) {
        
       try
        {
        if (silverlightControl != null)
            silverlightControl.Content.Page.ShowOnlyDoor(showOnlyDoor);
        }
        catch(err)
        {}


    }

    //readOnly
    function SetReadOnlyMode(readOnly,allValid) {
        try
        {
            if (silverlightControl != null) {
                silverlightControl.Content.Page.SetReadOnlyMode(readOnly, allValid);                
            }
        }
        catch(err)
        {}

    }




    //Save Modification
    function Save(primaryLanguageName, secondaryLanguageName, IsNewRecord) {

        try
        {
 
        if (silverlightControl != null)
            silverlightControl.Content.Page.Save(primaryLanguageName, secondaryLanguageName, IsNewRecord);
         }
        catch(err)
        {}
    }



    //event when the silverlight control is loaded
    function onSilverLightLoaded(sender, args) {
        silverlightControl = document.getElementById('silverlightControl');
        SetReadOnlyMode('<%= this.IsReadOnly?"1":"0" %>', '<%= this.IsAllValid?"1":"0" %>');
        ShowOnlyDoor('<%= this.IsShowOnlyDoor?"1":"0" %>'); 
//        silverlightControl.Content.Page.ResizeTreeView(silverlightControl.offsetHeight);
    }
 

    function setSilverlightSize(val) {
        var host = document.getElementById("silverlightGraphicViewHost"); host.style.height = val + "px";
    }
 
     
</script>

<div id="silverlightGraphicViewHost">
    <object id="silverlightControl" width="100%" height="100%" data="data:application/x-silverlight-2,"
        type="application/x-silverlight-2">
        <param name="source" value="../ClientBin/Kantech.Silverlight.AccessLevel.xap" />
        <param name="onError" value="onSilverlightError" />
        <param name="background" value="white" />
        <param name="minRuntimeVersion" value="4.0.50524.0" />
        <param name="onerror" value="onSilverlightError" />
        <param name="onload" value="onSilverLightLoaded" />
        <param name="autoUpgrade" value="true" />

        <script type="text/javascript">
            if (Prototype.Browser.Gecko)
                document.write("<param name='Windowless' value='false' />");
            else
                document.write("<param name='Windowless' value='true' />");    
        </script>

        <%--decrease performance when true--%>
        <param name="EnableGPUAcceleration" value="true" />
        <param runat="server" name="initParams" id="SilverLightInitParams" value="" />
        <a href="http://go.microsoft.com/fwlink/?LinkID=149156&v=4.0.50524.0" style="text-decoration: none">
            <img src="http://go.microsoft.com/fwlink/?LinkId=161376" alt="Get Microsoft Silverlight"
                style="border-style: none" />
        </a>
    </object>
</div>
