<%@ Page Language="C#" MasterPageFile="~/Common/MasterPage/MasterPage.master" 
    AutoEventWireup="true" CodeBehind="AccessLevelEdit.aspx.cs" Inherits="WebStation.AccessLevels.AccessLevelEdit"
    meta:resourcekey="PageResource1" %>

<%@ Register TagPrefix="dbwc" Namespace="DBauer.Web.UI.WebControls" Assembly="DBauer.Web.UI.WebControls.DynamicControlsPlaceholder" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register Src="AccessLevelGraphicView.ascx" TagName="AccessLevelGraphicView" TagPrefix="kantech" %>
<%@ Register Src="AccessLevelClassicView.ascx" TagName="AccessLevelClassicView" TagPrefix="kantech" %>
<asp:Content ID="AccessLevelsEditContent" ContentPlaceHolderID="Main" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
        <Scripts>
            <asp:ScriptReference Path="../Common/JavaScript/Silverlight.js" />
            <asp:ScriptReference Path="../Common/JavaScript/tooltip/wz_tooltip.js" />
            <asp:ScriptReference Path="../Common/JavaScript/prototype.js" />
        </Scripts>
    </asp:ScriptManager>
    <input type="hidden" runat="server" id="MustSetSilverlightVisible" />
    <input type="hidden" runat="server" id="MustSaveAs" />
    <input type="hidden" runat="server" id="MustAddNew" />
    <input type="hidden" runat="server" id="UpdateOperationSucceed" />
    <input type="hidden" runat="server" id="AddOperationSucceed" />
    <input type="hidden" runat="server" id="SelectedRowID" />
    <input type="hidden" runat="server" id="hfIsDirty" enableviewstate="true" />
    <input type="hidden" runat="server" id="RedirectToScheduleID" />
    <input type="hidden" runat="server" id="SilverlightError" />
    
    <div id="divAccessLevels">
        <asp:UpdatePanel ID="upAccessLevel" runat="server">
            <ContentTemplate>
                <div id="divMessageOperationFeedBack">
                    <asp:Button runat="server" ID="TargetControlForMessageOperationFeedBack" Style="display: none"
                        meta:resourcekey="TargetControlForMessageOperationFeedBackResource1" />
                    <ajaxToolkit:ModalPopupExtender runat="server" ID="ModalPopupMessageOperationFeedBack"
                        BehaviorID="ModalPopupBehaviorMessageOperationFeedBack" TargetControlID="TargetControlForMessageOperationFeedBack"
                        PopupControlID="PanelMessageOperationFeedBack" BackgroundCssClass="modalBackground"
                        CancelControlID="btnOk" DynamicServicePath="" Enabled="True">
                    </ajaxToolkit:ModalPopupExtender>
                    <asp:Panel ID="PanelMessageOperationFeedBack" runat="server" Style="display: none;
                        padding: 20px" CssClass="modalMessage" meta:resourcekey="PanelMessageOperationFeedBackResource1">
                        <div>
                            <asp:Label runat="server" ID="lblMessageOperationFeedBack" Text="<%$ Resources:AppResource, test %>" meta:resourcekey="lblMessageOperationFeedBackResource1"></asp:Label><br />
                            <br />
                        </div>
                        <div style="text-align: center;">
                            <asp:Button ID="btnOk" Width="75px" Height="23px" runat="server" OnClientClick="ShowSilverLightObject()"
                                Text="<%$ Resources:AppResource, btnOK %>" meta:resourcekey="btnOkResource1" />
                        </div>
                    </asp:Panel>
                </div>
                <input type="hidden" runat="server" id="DoSaveAs" />
                <div id="messagePanelSaveAs">
                    <asp:Button ID="targetControlSaveAs" runat="server" meta:resourcekey="targetControlSaveAsResource1"
                        Style="display: none" />
                    <ajaxToolkit:ConfirmButtonExtender ID="ConfirmButtonExtenderSaveAs" runat="server"
                        ConfirmText="" DisplayModalPopupID="ModalPopupExtenderSaveAs" Enabled="True"
                        TargetControlID="targetControlSaveAs">
                    </ajaxToolkit:ConfirmButtonExtender>
                    <br />
                    <ajaxToolkit:ModalPopupExtender ID="ModalPopupExtenderSaveAs" runat="server" BackgroundCssClass="modalBackground"
                        CancelControlID="btnSaveAs_Cancel" DynamicServicePath="" Enabled="True" OkControlID="btnSaveAs_OK"
                        PopupControlID="PNL" TargetControlID="targetControlSaveAs">
                    </ajaxToolkit:ModalPopupExtender>
                    <asp:Panel ID="PNL" runat="server" CssClass="modalMessage" meta:resourcekey="PNLResource1"
                        Style="display: none; padding: 20px">
                        <div style="text-align: left;">
                            <asp:Label ID="lblNewSchedulelName" runat="server" meta:resourceKey="lblNewSchedulelNameResource1"
                                Text="<%$ Resources:AppResource,  messAccessLevelSaveAs %>"></asp:Label>
                            <br />
                            <br />
                            <asp:Label ID="lblSaveAsPrimaryLanguage" runat="server" 
                                 Width="80px"></asp:Label>
                            <asp:TextBox ID="txtSaveAsPrimaryLanguage" runat="server" CssClass="SaveAsDesc" MaxLength="40"
                                meta:resourcekey="txtSaveAsPrimaryLanguageResource1" TabIndex="2" Width="200px"></asp:TextBox>
                            <br />
                            <asp:Label ID="lblSaveAsSecondaryLanguage" runat="server" 
                                Width="80px"></asp:Label>
                            <asp:TextBox ID="txtSaveAsSecondaryLanguage" runat="server" CssClass="SaveAsDesc"
                                MaxLength="40" meta:resourcekey="txtSaveAsSecondaryLanguageResource1" TabIndex="3"
                                Width="200px"></asp:TextBox>
                        </div>
                        <br />
                        <div style="text-align: center;">
                            <asp:Button ID="btnSaveAs_OK" runat="server" Height="23px" meta:resourcekey="btnSaveAs_OKResource1"
                                OnClientClick="SaveAs();" Text="<%$ Resources:AppResource, btnOK %>" Width="75px" />
                            <asp:Button ID="btnSaveAs_Cancel" runat="server" Height="23px" meta:resourcekey="btnSaveAs_CancelResource1"
                                OnClientClick="ShowSilverLightObject(); " Text="<%$ Resources:AppResource, btnCancel %>"
                                Width="75px" />
                        </div>
                    </asp:Panel>
                </div>
                <div id="MessageError">
                    <asp:Button ID="btnMessageError" runat="server" meta:resourcekey="btnMessageErrorResource1"
                        Style="display: none" />
                    <ajaxToolkit:ModalPopupExtender ID="ModalPopupExtenderMessageError" runat="server"
                        BackgroundCssClass="modalBackground" BehaviorID="ModalPopupBehaviorMessageError"
                        DynamicServicePath="" Enabled="True" PopupControlID="PanelMessageError" TargetControlID="btnMessageError">
                    </ajaxToolkit:ModalPopupExtender>
                    <asp:Panel ID="PanelMessageError" runat="server" CssClass="modalMessage" meta:resourcekey="PanelMessageErrorResource1"
                        Style="display: none; padding: 20px">
                        <div>
                            <asp:Label ID="lblMessageError" runat="server" meta:resourcekey="lblMessageErrorResource1"></asp:Label>
                            <br />
                            <br />
                        </div>
                        <div style="text-align: center;">
                            <asp:Button ID="btnOKMessageError" runat="server" Height="23px" meta:resourcekey="btnOKMessageErrorResource1"
                                OnClick="btnOKMessageError_Click" OnClientClick="checkForReloadPage();ShowSilverLightObject();"
                                Text="<%$ Resources:AppResource, btnOK %>" Width="75px" />
                        </div>
                    </asp:Panel>
                </div>
                <div id="divMessageConfirmation">
                    <asp:Button ID="TargetControlForMessageConfirmation" runat="server" meta:resourcekey="TargetControlForMessageConfirmationResource1"
                        Style="display: none" />
                    <asp:HiddenField ID="MessageConfirmationActionValue" runat="server" />
                    <ajaxToolkit:ModalPopupExtender ID="ModalPopupConfirmation" runat="server" BackgroundCssClass="modalBackground"
                        BehaviorID="ModalPopupBehaviorMessageOK" CancelControlID="ButtonCancel" DynamicServicePath=""
                        Enabled="True" PopupControlID="PanelMessageConfirmation" TargetControlID="TargetControlForMessageConfirmation">
                    </ajaxToolkit:ModalPopupExtender>
                    <asp:Panel ID="PanelMessageConfirmation" runat="server" CssClass="modalMessage" meta:resourcekey="PanelMessageConfirmationResource1"
                        Style="display: none; padding: 20px">
                        <asp:Label ID="lblMessageConfirmation" runat="server" meta:resourcekey="lblMessageConfirmationResource1"></asp:Label>
                        <asp:TextBox ID="txtPKDATA" runat="server" meta:resourcekey="txtPKDATAResource1"
                            Style="display: none"></asp:TextBox>
                        <br />
                        <br />
                        <div style="text-align: center;">
                            <asp:Button ID="ButtonOk" runat="server" Height="23px" meta:resourcekey="ButtonOkResource1"
                                OnClick="btnConfirmationOK_Click" OnClientClick="HideConfirmationPopup();" Text="<%$ Resources:AppResource, btnOK %>"
                                Width="75px" />
                            <asp:Button ID="ButtonCancel" runat="server" Height="23px" meta:resourcekey="ButtonCancelResource1"
                                OnClientClick="ShowSilverLightObject();" Text="<%$ Resources:AppResource, btnCancel %>"
                                Width="75px" />
                        </div>
                    </asp:Panel>
                </div>
                <table id="tabAccessLevelsHeader" style="width: 100%">
                    <tr>
                        <th align="left" style="width: 40%">
                            <asp:Label ID="lblGateway" runat="server" meta:resourcekey="lblGatewayResource1"
                                Style="padding-bottom: 3px" Width="110px" Text="<%$ Resources:AppResource, AccessLevelGatewaySite%>">Gateway/Site:</asp:Label>
                            <asp:DropDownList ID="ddlGateway" runat="server" AutoPostBack="True" Width="240px" CssClass="DropdownListAcessLevel" TabIndex="1"
                                meta:resourcekey="ddlGatewayResource1" OnSelectedIndexChanged="ddlGateway_SelectedIndexChanged"
                                 >
                            </asp:DropDownList>
                        </th>
                        <th align="left">
                            <asp:Label ID="lblLanguage1Label" runat="server" CssClass="LanguageAccessLevelLabel"  Width="230px"
                                > </asp:Label>
                            <asp:TextBox ID="txtLanguage1" runat="server" CssClass="TextBoxAccessLevels" MaxLength="40"
                                meta:resourcekey="txtLanguage1Resource1" TabIndex="3" OnChange="javascript:SetDirty();"></asp:TextBox>
                        </th>
                    </tr>
                    <tr>
                        <th align="left">
                            <asp:Label ID="lblAccessLevelsList" runat="server" CssClass="labelFields" meta:resourcekey="lblAccessLevelsListResource1"
                                Style="padding-bottom: 3px" Width="110px" Text="<%$ Resources:AppResource, AccessLevel %>">Access Level:</asp:Label>
                            <asp:DropDownList ID="ddlAccessLevels" runat="server" AutoPostBack="True" 	Width="240px" CssClass="DropdownListAcessLevel"
                                meta:resourcekey="ddlAccessLevelsResource1" OnSelectedIndexChanged="ddlAccessLevels_SelectedIndexChanged"
                                TabIndex="2" >
                            </asp:DropDownList>
                            <img id="imgReadOnly" runat="server" src="../Common/Images/readOnly.gif" style="vertical-align: bottom"></img>
                        </th>
                        <th align="left">
                            <asp:Label ID="lblLanguage2Label" runat="server"   CssClass="LanguageAccessLevelLabel" 
                                 Width="230px"> </asp:Label>
                            <asp:TextBox ID="txtLanguage2" runat="server" CssClass="TextBoxAccessLevels" MaxLength="40"
                                meta:resourcekey="txtLanguage2Resource1" OnChange="javascript:SetDirty();" TabIndex="4"></asp:TextBox>
                        </th>
                        <tr>
                            <th align="left"   style="padding-top: 20px">
                                <asp:ImageButton ID="lnkSwitchToClassic" Width="40px" Height="40px" runat="server"  ImageAlign="Middle"
                                    meta:resourcekey="lnkSwitchToClassicResource1"   OnClick="lnkSwitchButton_OnClick" 
                                    CssClass="SwitchViewLink"  
                                      ></asp:ImageButton>
                                <asp:ImageButton ID="lnkSwitchToGraphical" runat="server" 
                                    CssClass="SwitchViewLink"  
                                    meta:resourcekey="lnkSwitchToGraphicalResource1" 
                                    OnClick="lnkSwitchButton_OnClick"   ImageAlign="Middle"
                                    Width="40px" Height="40px"      />
                            </th>
                            <th>
                                &nbsp;</th>
                        </tr>
                    </tr>
                </table>
                <dbwc:DynamicControlsPlaceholder ID="dynamicControlClassicView" runat="server">
                </dbwc:DynamicControlsPlaceholder>
            </ContentTemplate>
        </asp:UpdatePanel>
        <dbwc:DynamicControlsPlaceholder ID="dynamicControlGraphicalView" runat="server">
        </dbwc:DynamicControlsPlaceholder>
        <asp:UpdatePanel ID="upButtons" runat="server">
            <ContentTemplate>
                <div id="divButtons" runat="server" class="divButtons">
                    <table id="tblButtons">
                        <tr align="left">
                            <td align="left">
                                <asp:Button ID="btnSave" runat="server" OnClick="btnSaveAccessLevel_Click" TabIndex="30"
                                    Text="<%$ Resources:AppResource, AccessLevelSave %>" meta:resourcekey="btnSaveResource1" />
                            </td>
                            <td>
                                <asp:Button ID="btnSaveAs" CssClass="Operationbutton" runat="server" OnClick="btnSaveAs_Click"
                                    TabIndex="31" Text="<%$ Resources:AppResource, AccessLevelSaveAs %>" meta:resourcekey="btnSaveAsResource1" />
                            </td>
                            <td>
                                <asp:Button ID="btnCancel" CssClass="Operationbutton" TabIndex="32" runat="server"
                                    OnClick="btnCancel_Click" OnClientClick="SetConfirmationActionValue('CANCEL')"
                                    Text="<%$ Resources:AppResource, AccessLevelCancel %>" meta:resourcekey="btnCancelResource1" />
                            </td>
                            <td>
                                <asp:Button ID="btnDelete" CssClass="Operationbutton" TabIndex="33" runat="server"
                                    OnClick="btnDelete_Click" OnClientClick="SetConfirmationActionValue('DELETE')"
                                    Text="<%$ Resources:AppResource, AccessLevelDelete %>" meta:resourcekey="btnDeleteResource1" />
                            </td>
                            <td>
                                <asp:Button ID="btnAddAccessLevel" CssClass="Operationbutton" TabIndex="34" runat="server"
                                    OnClientClick="javascript:AddNewRecord();" 
                                    Text="<%$ Resources:AppResource, AccessLevelAddNew %>" 
                                    meta:resourcekey="btnAddAccessLevelResource1" 
                                    onclick="btnAddAccessLevel_Click" />
                            </td>
                        </tr>
                    </table>
                </div>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>

    <script type="text/javascript">


        var reloadPageURL = "";
        var reloadPageAction = "";

        function HideConfirmationPopup() {
            $find('ModalPopupBehaviorMessageOK').hide();
        }


        function SetConfirmationActionValue(value) {
            window.document.getElementById('<%=this.MessageConfirmationActionValue.ClientID %>').value = value;
        }


        function closeWin() {
            document.forms[0].submit();
        }



        function checkForReloadPage() {
            if (reloadPageAction == "true") {
                window.location = reloadPageActionURL;
            }
        }


        function callAlertMessage(mess, imagecode, reload, path) {
            AlertMessagePanel(mess, imagecode, reload, path);
        }


        function AlertMessagePanel(msg, code, reload, path) {
            var myBehavior = $find("ModalPopupBehaviorMessageError");
            window.document.getElementById('<%=this.lblMessageError.ClientID %>').innerHTML = msg;
            myBehavior.show();

            HideSilverLightObject();

            if (reload == "true") {
                reloadPageAction = "true";
                pos = location.href.lastIndexOf('/') + 1;
                str = location.href.substring(0, pos);
                reloadPageActionURL = str + path;
            }
            else
                reloadPageAction = "false";

        }





        //Puts the IsDirty to true to indicates that a modification has been made
        function SetDirty() {
            if (document.getElementById('<%= hfIsDirty.ClientID  %>').value == "0") {
                document.getElementById('<%= btnSave.ClientID  %>').disabled = false;
                document.getElementById('<%= btnCancel.ClientID  %>').disabled = false;
                document.getElementById('<%= hfIsDirty.ClientID  %>').value = "1";
            }
        }



        //Partial Postback to do the Save As Operation
        function SaveAs() {
            window.document.getElementById('<%=this.MustSaveAs.ClientID %>').value = 1;
            __doPostBack('<%=this.upAccessLevel.ClientID %>', '');
        }



        //Partial Postback to add a new record
        function AddNewRecord() {

            window.document.getElementById('<%=this.MustAddNew.ClientID %>').value = 1;
            __doPostBack('<%=this.upAccessLevel.ClientID %>', '');
        }




        function UpdateOperationSucceed() {
            window.document.getElementById('<%=this.UpdateOperationSucceed.ClientID %>').value = 1;
            __doPostBack('<%=this.upAccessLevel.ClientID %>', '');
        }


        function AddOperationSucceed(accessLevelid) {
            window.document.getElementById('<%=this.AddOperationSucceed.ClientID %>').value = accessLevelid;
            __doPostBack('<%=this.upAccessLevel.ClientID %>', '');
        }


        function RedirectToScheduleID(scheduleID) {
            window.document.getElementById('<%=this.RedirectToScheduleID.ClientID %>').value = scheduleID;
            __doPostBack('<%=this.upAccessLevel.ClientID %>', '');
        }


        function HideSilverLightObject() {
            var objSilverlight = document.getElementById("silverlightControl");

            if (objSilverlight != null) {
                window.document.getElementById('<%=this.MustSetSilverlightVisible.ClientID %>').value = "1";
                objSilverlight.style.visibility = 'hidden';
            }


        }

        function ShowSilverLightObject() {
            var objSilverlight = document.getElementById("silverlightControl");

            if (objSilverlight != null) {
                document.getElementById("silverlightControl").style.visibility = 'visible';
            }

            window.document.getElementById('<%=this.MustSetSilverlightVisible.ClientID %>').value = "";


        }
        //Receives notification from silverlight
        //the  params is an variable array of string
        function NotifyFromSilverlight(param1, param2) {
            //update
            if (param1 == "update") {
                UpdateOperationSucceed();
            }

            //Add
            if (param1 == "add") {
                //sends the new accesslevelid
                AddOperationSucceed(param2);
            }

            if (param1 == "RedirectToScheduleID") {
                //sends the new accesslevelid
                RedirectToScheduleID(param2);
            }
        }
 

    </script>

</asp:Content>
