﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="AccessLevelClassicView.ascx.cs"
    Inherits="WebStation.AccessLevels.AccessLevelClassicView" %>
    
    
<input type="hidden" runat="server" id="batchMenu" />
     
<div id="divClassicViewScroll"  >
    <asp:GridView ID="gvAccessLevels" runat="server" AutoGenerateColumns="False" OnRowDataBound="gvAccessLevel_RowDataBound"
          OnRowCreated="gvAccessLevel_RowCreated" 
        OnRowCommand="gvAccessLevel_RowCommand"
        OnSorting="gvAccessLevel_Sorting"   UseAccessibleHeader="False"
        CssClass="GridViewAccessLevel" AllowSorting="True" AllowPaging="false"   
        Caption="<%$ Resources:AppResource, AccessLevelClassicViewHeader %>"
        CaptionAlign="Top"  
        >
        <EditRowStyle CssClass="GridViewRow" />
        <HeaderStyle CssClass="GridViewHeader" />
        <RowStyle CssClass="GridViewRow"   />
        <PagerStyle CssClass="GridViewPager" />
        <AlternatingRowStyle CssClass="GridViewAlterRow" />
                
        <Columns>       
            <asp:TemplateField SortExpression="DoorDescription"   
                meta:resourcekey="TemplateFieldResource1">
                <ItemTemplate>
                    <asp:Image ID="imgDoorType" runat="server"  Width="13px" Height="15px" 
                        style="vertical-align:middle" meta:resourcekey="imgDoorTypeResource1"/>
                    <asp:Label ID="lblDoorName" runat="server" 
                        meta:resourcekey="lblDoorNameResource1"></asp:Label>
                </ItemTemplate>
                <ItemStyle />
            </asp:TemplateField>
            <asp:TemplateField SortExpression="ScheduleDescription"  >
                <ItemTemplate>
                    <asp:Label ID="lblSchedule" runat="server" 
                        meta:resourcekey="lblScheduleResource1"></asp:Label>
                    <asp:DropDownList ID="ddlSchedule" runat="server" AutoPostBack="True" Width="175px"
                        OnSelectedIndexChanged="ddlSchedule_SelectedIndexChanged" 
                        CssClass="ComboBoxAccessLevels" meta:resourcekey="ddlScheduleResource1">
                    </asp:DropDownList>
                </ItemTemplate>
                <ItemStyle />
            </asp:TemplateField>
            <asp:TemplateField SortExpression="FloorGroupDescription" >
               
                <ItemTemplate>
                    <asp:Label ID="lblFloorGroup" runat="server" 
                        meta:resourcekey="lblFloorGroupResource1"></asp:Label>
                    <asp:DropDownList ID="ddlFloorGroup" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlFloorGroup_SelectedIndexChanged"
                        Width="175px" CssClass="ComboBoxAccessLevels" 
                        meta:resourcekey="ddlFloorGroupResource1">
                    </asp:DropDownList>
                </ItemTemplate>
                <ItemStyle />
            </asp:TemplateField>
                <asp:TemplateField ItemStyle-Width="160px" 
                ItemStyle-HorizontalAlign="Center" HeaderStyle-HorizontalAlign="Center" 
                HeaderStyle-VerticalAlign="Middle" meta:resourcekey="TemplateFieldResource4">
                <ItemTemplate>
                    <asp:CheckBox ID="chkSelect" runat="server" 
                        meta:resourcekey="chkSelectResource1"></asp:CheckBox>                  
                </ItemTemplate>
                <HeaderTemplate>
                    <asp:DropDownList ID="ddlBatchMode" CssClass="BatchModeStyle" runat="server" AutoPostBack="True" 
                        onselectedindexchanged="ddlBatchMode_SelectedIndexChanged" 
                        meta:resourcekey="ddlBatchModeResource1" >
                        <asp:ListItem Text="<%$ Resources:AppResource, SimpleUpdateMode %>" Value="0" 
                            meta:resourcekey="ListItemResource1"></asp:ListItem>
                        <asp:ListItem Text="<%$ Resources:AppResource, MultipleUpdateMode %>" Value="1" 
                            meta:resourcekey="ListItemResource2"></asp:ListItem>
                    </asp:DropDownList>
                   <br />
                     <asp:LinkButton ID="hlSelectAll" CommandName="SelectAll" runat="server" 
                        NavigateUrl="~/AccessLevels/AccessLevelsEdit.aspx" 
                        meta:resourcekey="hlSelectAllResource1" Text="<%$ Resources:AppResource, AccessLevelSelectAll %>"   >Select All</asp:LinkButton>
                    <label id="lblBatchModeSeparator" runat="server" style="margin-left:2px;margin-right:2px">|</label> 
                     &nbsp;<asp:LinkButton ID="hlUnselectAll" 
                        CommandName="UnSelectAll" runat="server"  Text="<%$ Resources:AppResource, AccessLevelUnselectAll %>" 
                        NavigateUrl="~/AccessLevels/AccessLevelsEdit.aspx" 
                        meta:resourcekey="hlUnselectAllResource1">Unselect All</asp:LinkButton>

             </HeaderTemplate>

            <HeaderStyle HorizontalAlign="Center"></HeaderStyle>

                <ItemStyle />
            </asp:TemplateField>
 
            
        </Columns>
        
        <PagerTemplate>
            <%--<div id="pageNave" onclick="javascript:emptyTxtFilter();">
                <asp:ImageButton ID="First" ToolTip="<%$ Resources:AppResource, AlternateTextFirst %>"
                    runat="server" CommandArgument="First" CommandName="Page" 
                    ImageUrl="../Common/Images/BTN/First.jpg" meta:resourcekey="FirstResource1" />
                <asp:ImageButton ID="Prev" ToolTip="<%$ Resources:AppResource, AlternateTextPrev %>"
                    runat="server" CommandArgument="Prev" CommandName="Page" 
                    ImageUrl="../Common/Images/BTN/Prev.jpg" meta:resourcekey="PrevResource1" />
                <asp:Label ID="Label5" runat="server" 
                    Text="<%$ Resources:AppResource, labelPagerPage %>" 
                    meta:resourcekey="Label5Resource1"></asp:Label>
                <asp:DropDownList ID="ddlPages" OnSelectedIndexChanged="ddlPages_SelectedIndexChanged"
                    CssClass="txtPagerDDL" runat="server" AutoPostBack="True" 
                    meta:resourcekey="ddlPagesResource1">
                </asp:DropDownList>
                <asp:Label ID="Label4" runat="server" 
                    Text="<%$ Resources:AppResource, labelPagerOF %>" 
                    meta:resourcekey="Label4Resource1"></asp:Label>&nbsp;<asp:Label
                    ID="lblPageCount" runat="server" meta:resourcekey="lblPageCountResource1"></asp:Label>
                <asp:ImageButton ID="Next" ToolTip="<%$ Resources:AppResource, AlternateTextNext %>"
                    runat="server" CommandArgument="Next" CommandName="Page" 
                    ImageUrl="../Common/Images/BTN/Next.jpg" meta:resourcekey="NextResource1" />
                <asp:ImageButton ID="Last" ToolTip="<%$ Resources:AppResource, AlternateTextLast %>"
                    runat="server" CommandArgument="Last" CommandName="Page" 
                    ImageUrl="../Common/Images/BTN/Last.jpg" meta:resourcekey="LastResource1" />
            </div>--%>
        </PagerTemplate>
        <EmptyDataTemplate>
        <br />
            <asp:Label  runat="server" Text="|DYNAMIC|" ForeColor="Red" Font-Size="11px" 
                Font-Names="Verdana" meta:resourcekey="LabelResource1"></asp:Label>
         <br />
        </EmptyDataTemplate>
        <SelectedRowStyle BackColor="Silver" BorderColor="#404040" />
    </asp:GridView>
    
 
</div>

