-- Table Type of ActiveDirectory.adt is ADT
Create Table ActiveDirectory(
   PkData Integer,
   FkObject Integer,
   FkParent Integer,
   MasterAccount Integer,
   Account Integer,
   Cluster Integer,
   NTM Integer,
   GSI Integer,
   Site Integer,
   Info1 Integer,
   Info2 Integer,
   Info3 Integer,
   Info4 Integer,
   State Short,
   TransactionId Integer,
   TransactionTag TimeStamp,
   Description1 Char( 100 ),
   Description2 Char( 100 ),
   EnableDirectoryService Short,
   IpAddress Char( 15 ),
   UseDomainName Short,
   DomainName Char( 64 ),
   Port Integer,
   UseSSL Short,
   SyncInterval Integer,
   LDAPSchema Char( 100 ),
   LDAPBaseDN Char( 255 ),
   LDAPBaseDNUser Char( 255 ),
   LDAPBindingDN Char( 255 ),
   LDAPPassword Char( 48 ),
   FkAdSmartlink Integer,
   SizeOfMapping Integer,
   Mapping Blob,
   SizeOfUserMapping Integer,
   UserMapping Blob,
   ADAvailableFields Memo,
   LastSync TimeStamp,
   XMLData Memo );

EXECUTE PROCEDURE sp_CreateIndex90( 'ActiveDirectory', 'ActiveDirectory.adi', 'PRIMARY', 'PkData', '', 2051, 1024, 'GENERAL_VFP_CI_AS_1252' );
EXECUTE PROCEDURE sp_CreateIndex90( 'ActiveDirectory', 'ActiveDirectory.adi', 'SKD1_ACTIVEDIRECTORY', 'MasterAccount;Account;Description1;PkData', '', 2051, 1024, 'GENERAL_VFP_CI_AS_1252' );
EXECUTE PROCEDURE sp_CreateIndex90( 'ActiveDirectory', 'ActiveDirectory.adi', 'SKD2_ACTIVEDIRECTORY', 'MasterAccount;Account;Description2;PkData', '', 2051, 1024, 'GENERAL_VFP_CI_AS_1252' );
EXECUTE PROCEDURE sp_CreateIndex90( 'ActiveDirectory', 'ActiveDirectory.adi', 'SK_ACTIVEDIRECTORY_PARENT', 'State;FkParent;MasterAccount;Account', '', 2, 1024, 'GENERAL_VFP_CI_AS_1252' );
EXECUTE PROCEDURE sp_CreateIndex90( 'ActiveDirectory', 'ActiveDirectory.adi', 'SK_ACTIVEDIRECTORY_PARENTNA', 'State;FkParent;MasterAccount', '', 2, 1024, 'GENERAL_VFP_CI_AS_1252' );
EXECUTE PROCEDURE sp_CreateIndex90( 'ActiveDirectory', 'ActiveDirectory.adi', 'SK_ACTIVEDIRECTORY_REGISTRYPATH', 'State;MasterAccount;Account;NTM;GSI', '', 2, 1024, 'GENERAL_VFP_CI_AS_1252' );
EXECUTE PROCEDURE sp_CreateIndex90( 'ActiveDirectory', 'ActiveDirectory.adi', 'SK_ACTIVEDIRECTORY_REGISTRYPATHNA', 'State;MasterAccount;NTM;GSI', '', 2, 1024, 'GENERAL_VFP_CI_AS_1252' );
EXECUTE PROCEDURE sp_CreateIndex90( 'ActiveDirectory', 'ActiveDirectory.adi', 'SK_ACTIVEDIRECTORY_REGISTRY', 'State;MasterAccount;Account', '', 2, 1024, 'GENERAL_VFP_CI_AS_1252' );
EXECUTE PROCEDURE sp_CreateIndex90( 'ActiveDirectory', 'ActiveDirectory.adi', 'SK_ACTIVEDIRECTORY_REGISTRYNA', 'State;MasterAccount', '', 2, 1024, 'GENERAL_VFP_CI_AS_1252' );
EXECUTE PROCEDURE sp_CreateIndex90( 'ActiveDirectory', 'ActiveDirectory.adi', 'SK_ACTIVEDIRECTORY_UNIQUEPATH', 'MasterAccount;Account;Cluster;NTM;GSI;Site;Info1;Info2;Info3;Info4;State', '', 2, 1024, 'GENERAL_VFP_CI_AS_1252' );

