-- Table Type of AllLanguage.adt is ADT
Create Table AllLanguage(
   EnglishName Char( 32 ),
   NativeName Char( 32 ),
   PrimaryId Short,
   SubIds Char( 32 ),
   DefaultSubId Short,
   FontName Char( 32 ),
   FontSize Short,
   Options Short,
   Charset Short,
   CodePage Short,
   ISOLanguage Char( 2 ),
   ISOCountries Char( 32 ),
   ISODefaultCountry Char( 2 ),
   DatabaseDescriptionInfo Char( 40 ),
   DatabaseDescriptionSet Char( 40 ) );


INSERT INTO "AllLanguage" VALUES( 'Native', 'Native', 0, NULL, 0, NULL, 0, 2, 0, 0, NULL, NULL, NULL, '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Afrikaans', 'Afrikaans', 54, NULL, 1, NULL, 0, 0, 0, 1252, 'af', NULL, 'ZA', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Albanian', 'shqipe', 28, NULL, 1, NULL, 0, 0, 238, 1250, 'sq', NULL, 'AL', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1250' );
INSERT INTO "AllLanguage" VALUES( 'Arabic', '', 1, NULL, 17, NULL, 0, 0, 178, 1256, 'ar', NULL, 'SA', 'Borland ANSI Arabic', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Arabic (Algeria)', ' ()', 1, '5', 5, NULL, 0, 0, 178, 1256, 'ar', NULL, 'DZ', 'Borland ANSI Arabic', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Arabic (Bahrain)', ' ()', 1, '15', 15, NULL, 0, 0, 178, 1256, 'ar', NULL, 'BH', 'Borland ANSI Arabic', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Arabic (Egypt)', ' ()', 1, '3', 3, NULL, 0, 0, 178, 1256, 'ar', NULL, 'EG', 'Borland ANSI Arabic', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Arabic (Iraq)', ' ()', 1, '2', 2, NULL, 0, 0, 178, 1256, 'ar', NULL, 'IQ', 'Borland ANSI Arabic', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Arabic (Jordan)', ' ()', 1, '11', 11, NULL, 0, 0, 178, 1256, 'ar', NULL, 'JO', 'Borland ANSI Arabic', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Arabic (Kuwait)', ' ()', 1, '13', 13, NULL, 0, 0, 178, 1256, 'ar', NULL, 'KW', 'Borland ANSI Arabic', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Arabic (Lebanon)', ' ()', 1, '12', 12, NULL, 0, 0, 178, 1256, 'ar', NULL, 'LB', 'Borland ANSI Arabic', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Arabic (Libya)', ' ()', 1, '4', 4, NULL, 0, 0, 178, 1256, 'ar', NULL, 'LY', 'Borland ANSI Arabic', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Arabic (Morocco)', ' ( )', 1, '6', 6, NULL, 0, 0, 178, 1256, 'ar', NULL, 'MA', 'Borland ANSI Arabic', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Arabic (Oman)', ' ()', 1, '8', 8, NULL, 0, 0, 178, 1256, 'ar', NULL, 'OM', 'Borland ANSI Arabic', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Arabic (Qatar)', ' ()', 1, '16', 16, NULL, 0, 0, 178, 1256, 'ar', NULL, 'QA', 'Borland ANSI Arabic', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Arabic (Saudi Arabia)', ' (  ', 1, '1', 1, NULL, 0, 0, 178, 1256, 'ar', NULL, 'SA', 'Borland ANSI Arabic', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Arabic (Syria)', ' ()', 1, '10', 10, NULL, 0, 0, 178, 1256, 'ar', NULL, 'SY', 'Borland ANSI Arabic', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Arabic (Tunisia)', ' ()', 1, '7', 7, NULL, 0, 0, 178, 1256, 'ar', NULL, 'TN', 'Borland ANSI Arabic', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Arabic (U.A.E.)', ' (  ', 1, '14', 14, NULL, 0, 0, 178, 1256, 'ar', NULL, 'AE', 'Borland ANSI Arabic', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Arabic (Yemen)', ' ()', 1, '9', 9, NULL, 0, 0, 178, 1256, 'ar', NULL, 'YE', 'Borland ANSI Arabic', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Assamese', 'Assamese', 77, NULL, 1, NULL, 0, 0, 0, 1252, '??', NULL, '??', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Azeri, Cyrillic', '??', 44, NULL, 1, NULL, 0, 0, 204, 1251, NULL, NULL, NULL, 'Pdox ANSI Cyrillic', 'RUSSIAN_VFP_CI_AS_1251' );
INSERT INTO "AllLanguage" VALUES( 'Azeri, Cyrillic (Azerbaijan)', '??, Cyrillic (??', 44, '2', 2, NULL, 0, 0, 204, 1251, NULL, '??', '??', 'Pdox ANSI Cyrillic', 'RUSSIAN_VFP_CI_AS_1251' );
INSERT INTO "AllLanguage" VALUES( 'Azeri, Latin', 'Az?rbaycanl', 44, NULL, 2, NULL, 0, 0, 162, 1254, NULL, NULL, NULL, 'Borland FRA Latin-1', 'GENERAL_VFP_CI_AS_1254' );
INSERT INTO "AllLanguage" VALUES( 'Azeri, Latin (Azerbaijan)', 'Az?rbaycanl, Latin (Az?rbayca', 44, '1', 1, NULL, 0, 0, 162, 1254, NULL, NULL, NULL, 'Borland FRA Latin-1', 'GENERAL_VFP_CI_AS_1254' );
INSERT INTO "AllLanguage" VALUES( 'Basque', 'Euskara', 45, NULL, 1, NULL, 0, 0, 0, 1252, 'eu', NULL, 'ES', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Belarusian', '', 35, NULL, 1, NULL, 0, 0, 204, 1251, 'be', NULL, 'BY', 'Pdox ANSI Cyrillic', 'RUSSIAN_VFP_CI_AS_1251' );
INSERT INTO "AllLanguage" VALUES( 'Bulgarian', '', 2, NULL, 1, NULL, 0, 0, 204, 1251, 'bg', NULL, 'BG', 'Pdox ANSI Bulgaria', 'RUSSIAN_VFP_CI_AS_1251' );
INSERT INTO "AllLanguage" VALUES( 'Catalan', 'catal', 3, NULL, 1, NULL, 0, 0, 0, 1252, 'ca', NULL, 'ES', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Chinese, Simplified', '', 4, NULL, 1, NULL, 0, 0, 134, 936, 'zh', NULL, 'CN', 'Paradox China 936', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Chinese, Simplified (People s Re', ', Simplified (л񹲺͹', 4, '2', 2, NULL, 0, 0, 134, 936, 'zh', 'CN', 'CN', 'Paradox China 936', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Chinese, Simplified (Singapore)', ', Simplified (¼)', 4, '4', 4, NULL, 0, 0, 134, 936, 'zh', 'SG', 'SG', 'Paradox China 936', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Chinese, Traditional', '', 4, NULL, 2, NULL, 0, 0, 136, 950, 'zh', NULL, 'HK', 'Paradox China 936', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Chinese, Traditional (Hong Kong)', ', Traditional ()', 4, '3', 3, NULL, 0, 0, 136, 950, 'zh', 'HK', 'HK', 'Paradox China 936', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Chinese, Traditional (Macau)', ', Traditional (D)', 4, '5', 5, NULL, 0, 0, 136, 950, 'zh', '??', '??', 'Paradox China 936', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Chinese, Traditional (Taiwan)', ', Traditional (xW)', 4, '1', 1, NULL, 0, 0, 136, 950, 'zh', 'TW', 'TW', 'Paradox China 936', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Croatian', 'hrvatski', 26, NULL, 2, NULL, 0, 0, 238, 1250, 'hr', NULL, 'HR', 'Paradox Czech 852', 'GENERAL_VFP_CI_AS_1250' );
INSERT INTO "AllLanguage" VALUES( 'Croatian (Croatia)', 'Croatian (Hrvatska)', 26, '1', 1, NULL, 0, 0, 238, 1250, 'hr', NULL, 'HR', 'Paradox Czech 852', 'GENERAL_VFP_CI_AS_1250' );
INSERT INTO "AllLanguage" VALUES( 'Czech', 'etina', 5, NULL, 1, NULL, 0, 0, 238, 1250, 'cs', NULL, 'CZ', 'Paradox Czech 852', 'CZECH_VFP_CI_AS_1250' );
INSERT INTO "AllLanguage" VALUES( 'Danish', 'dansk', 6, NULL, 1, NULL, 0, 0, 0, 1252, 'da', NULL, 'DK', 'Paradox ''nordan40''', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Dutch', 'Nederlands', 19, NULL, 3, NULL, 0, 0, 0, 1252, 'nl', NULL, 'NL', 'Paradox ''nordan40''', 'DUTCH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Dutch (Belgium)', 'Nederlands (Belgi)', 19, '2', 2, NULL, 0, 0, 0, 1252, 'nl', NULL, 'BE', 'Paradox ''nordan40''', 'DUTCH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Dutch (Netherlands)', 'Nederlands (Nederland)', 19, '1', 1, NULL, 0, 0, 0, 1252, 'nl', NULL, 'NL', 'Paradox ''nordan40''', 'DUTCH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'English (Australia)', 'English (Australia)', 9, '3', 3, NULL, 0, 0, 0, 1252, 'en', NULL, 'AU', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'English (Belize)', 'English (Belize)', 9, '10', 10, NULL, 0, 0, 0, 1252, 'en', NULL, 'BZ', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'English (Canada)', 'English (Canada)', 9, '4', 4, NULL, 0, 0, 0, 1252, 'en', NULL, 'CA', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'English (Caribbean)', 'English (Caribbean)', 9, '9', 9, NULL, 0, 0, 0, 1252, 'en', NULL, 'CB', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'English (Ireland)', 'English (Eire)', 9, '6', 6, NULL, 0, 0, 0, 1252, 'en', NULL, 'IE', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'English (Jamaica)', 'English (Jamaica)', 9, '8', 8, NULL, 0, 0, 0, 1252, 'en', NULL, 'JM', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'English (New Zealand)', 'English (New Zealand)', 9, '5', 5, NULL, 0, 0, 0, 1252, 'en', NULL, 'NZ', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'English (Republic of the Philipp', 'English (Philippines)', 9, '13', 13, NULL, 0, 0, 0, 1252, 'en', '??', '??', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'English (South Africa)', 'English (South Africa)', 9, '7', 7, NULL, 0, 0, 0, 1252, 'en', NULL, 'ZA', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'English (Trinidad y Tobago)', 'English (Trinidad y Tobago)', 9, '11', 11, NULL, 0, 0, 0, 1252, 'en', NULL, 'TT', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'English (United Kingdom)', 'English (United Kingdom)', 9, '2', 2, NULL, 0, 0, 0, 1252, 'en', NULL, 'GB', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'English (United States)', 'English (United States)', 9, '1', 1, NULL, 0, 0, 0, 1252, 'en', NULL, 'US', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'English (Zimbabwe)', 'English (Zimbabwe)', 9, '12', 12, NULL, 0, 0, 0, 1252, 'en', '??', '??', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Estonian', 'eesti', 37, NULL, 1, NULL, 0, 0, 186, 1257, 'et', NULL, 'EE', 'Pdox ANSI Cyrillic', 'Baltic_ADS_CS_AS_1257' );
INSERT INTO "AllLanguage" VALUES( 'Faeroese', 'froyskt', 56, NULL, 1, NULL, 0, 0, 0, 1252, 'fo', NULL, 'FO', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Farsi', '', 41, NULL, 1, NULL, 0, 0, 178, 1256, 'fa', NULL, 'IR', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Finnish', 'suomi', 11, NULL, 3, NULL, 0, 0, 0, 1252, 'fi', NULL, 'FI', 'Pdox ANSI Swedfin', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Finnish (Finland)', 'suomi (Suomi)', 11, '1', 1, NULL, 0, 0, 0, 1252, 'fi', NULL, 'FI', 'Pdox ANSI Swedfin', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Finnish (Sweden)', 'suomi (Ruotsi)', 11, '2', 2, NULL, 0, 0, 0, 1252, 'fi', 'SE', 'SE', 'Pdox ANSI Swedfin', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'French (Belgium)', 'franais (Belgique)', 12, '2', 2, NULL, 0, 0, 0, 1252, 'fr', NULL, 'BE', 'Borland FRA Latin-1', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'French (Canada)', 'franais (Canada)', 12, '3', 3, NULL, 0, 0, 0, 1252, 'fr', NULL, 'CA', 'Borland FRA Latin-1', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'French (France)', 'franais (France)', 12, '1', 1, NULL, 0, 0, 0, 1252, 'fr', NULL, 'FR', 'Borland FRA Latin-1', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'French (Luxembourg)', 'franais (Luxembourg)', 12, '5', 5, NULL, 0, 0, 0, 1252, 'fr', NULL, 'LU', 'Borland FRA Latin-1', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'French (Principality of Monaco)', 'franais (Principaut de Monaco)', 12, '6', 6, NULL, 0, 0, 0, 1252, 'fr', '??', '??', 'Borland FRA Latin-1', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'French (Switzerland)', 'franais (Suisse)', 12, '4', 4, NULL, 0, 0, 0, 1252, 'fr', NULL, 'CH', 'Borland FRA Latin-1', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'German', 'Deutsch', 7, NULL, 6, NULL, 0, 0, 0, 1252, 'de', NULL, 'DE', 'Pdox ANSI Czech', 'GERMAN_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'German (Austria)', 'Deutsch (sterreich)', 7, '3', 3, NULL, 0, 0, 0, 1252, 'de', NULL, 'AT', 'Pdox ANSI Czech', 'GERMAN_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'German (Germany)', 'Deutsch (Deutschland)', 7, '1', 1, NULL, 0, 0, 0, 1252, 'de', NULL, 'DE', 'Pdox ANSI Czech', 'GERMAN_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'German (Liechtenstein)', 'Deutsch (Liechtenstein)', 7, '5', 5, NULL, 0, 0, 0, 1252, 'de', NULL, 'LI', 'Pdox ANSI Czech', 'GERMAN_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'German (Luxembourg)', 'Deutsch (Luxemburg)', 7, '4', 4, NULL, 0, 0, 0, 1252, 'de', NULL, 'LU', 'Pdox ANSI Czech', 'GERMAN_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'German (Switzerland)', 'Deutsch (Schweiz)', 7, '2', 2, NULL, 0, 0, 0, 1252, 'de', NULL, 'CH', 'Pdox ANSI Czech', 'GERMAN_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Greek', '', 8, NULL, 1, NULL, 0, 0, 161, 1253, 'el', NULL, 'GR', 'Paradox Greek GR437', 'GREEK_VFP_CI_AS_1253' );
INSERT INTO "AllLanguage" VALUES( 'Hebrew', '', 13, NULL, 1, NULL, 0, 0, 177, 1255, 'he', NULL, 'IL', 'Paradox ''hebrew''', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Hungarian', 'magyar', 14, NULL, 1, NULL, 0, 0, 238, 1250, 'hu', NULL, 'HU', 'Paradox Hun 852 DC', 'HUNGARY_VFP_CI_AS_1250' );
INSERT INTO "AllLanguage" VALUES( 'Icelandic', 'slenska', 15, NULL, 1, NULL, 0, 0, 0, 1252, 'is', NULL, 'IS', 'Paradox ISL 861', 'ICELAND_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Indonesian', 'Bahasa Indonesia', 33, NULL, 1, NULL, 0, 0, 0, 1252, 'id', NULL, 'ID', '''ascii'' ANSI', 'ICELAND_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Italian', 'italiano', 16, NULL, 3, NULL, 0, 0, 0, 1252, 'it', NULL, 'IT', 'Borland FRA Latin-1', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Italian (Italy)', 'italiano (Italia)', 16, '1', 1, NULL, 0, 0, 0, 1252, 'it', NULL, 'IT', 'Borland FRA Latin-1', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Italian (Switzerland)', 'italiano (Svizzera)', 16, '2', 2, NULL, 0, 0, 0, 1252, 'it', NULL, 'CH', 'Borland FRA Latin-1', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Japanese', '{', 17, NULL, 1, NULL, 0, 0, 128, 932, 'ja', NULL, 'JP', 'Paradox ''japan''', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Kazakh', '?b', 63, NULL, 1, NULL, 0, 0, 204, 1251, '??', NULL, '??', 'Pdox ANSI Cyrillic', 'RUSSIAN_VFP_CI_AS_1251' );
INSERT INTO "AllLanguage" VALUES( 'Korean', 'ѱ', 18, NULL, 2, NULL, 0, 0, 129, 949, 'ko', NULL, 'KO', 'Paradox Korea 949', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Korean (Korea)', 'ѱ (ѹα)', 18, '1', 1, NULL, 0, 0, 129, 949, 'ko', 'KO', 'KO', 'Paradox Korea 949', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Korean, Johab', 'e', 18, NULL, 1, NULL, 0, 0, 130, 1361, 'ko', NULL, 'KO', 'Paradox Korea 949', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Korean, Johab (Johab)', 'e, Johab (Johab)', 18, '2', 2, NULL, 0, 0, 130, 1361, 'ko', 'KO', 'KO', 'Paradox Korea 949', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Latvian', 'latvieu', 38, NULL, 1, NULL, 0, 0, 186, 1257, 'lv', NULL, 'LV', 'Pdox ANSI Cyrillic', 'Baltic_ADS_CS_AS_1257' );
INSERT INTO "AllLanguage" VALUES( 'Lithuanian', 'lietuvi', 39, NULL, 1, NULL, 0, 0, 186, 1257, 'lt', NULL, 'LT', 'Pdox ANSI Cyrillic', 'Baltic_ADS_CS_AS_1257' );
INSERT INTO "AllLanguage" VALUES( 'Macedonian', ' ', 47, NULL, 1, NULL, 0, 0, 204, 1251, NULL, NULL, NULL, 'Paradox Greek GR437', 'RUSSIAN_VFP_CI_AS_1251' );
INSERT INTO "AllLanguage" VALUES( 'Malay', 'Bahasa Malaysia', 62, NULL, 3, NULL, 0, 0, 0, 1252, '??', NULL, '??', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Malay (Brunei Darussalam)', 'Bahasa Malaysia (Brunei Darussal', 62, '2', 2, NULL, 0, 0, 0, 1252, '??', '??', '??', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Malay (Malaysia)', 'Bahasa Malaysia (Malaysia)', 62, '1', 1, NULL, 0, 0, 0, 1252, '??', '??', '??', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Norwegian', 'norsk', 20, NULL, 3, NULL, 0, 0, 0, 1252, 'no', NULL, 'NO', 'Paradox ''nordan''', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Norwegian (Bokmal)', 'norsk (Bokmal)', 20, '1', 1, NULL, 0, 0, 0, 1252, 'no', NULL, 'NO', 'Paradox ''nordan''', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Norwegian (Nynorsk)', 'norsk (Nynorsk)', 20, '2', 2, NULL, 0, 0, 0, 1252, 'no', NULL, 'NO', 'Paradox ''nordan''', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Polish', 'polski', 21, NULL, 1, NULL, 0, 0, 238, 1250, 'pl', NULL, 'PL', 'Paradox Polish 852', 'POLISH_VFP_CI_AS_1250' );
INSERT INTO "AllLanguage" VALUES( 'Portuguese', 'Portugus', 22, NULL, 3, NULL, 0, 0, 0, 1252, 'pt', NULL, 'BR', 'Pdox ANSI Spanish', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Portuguese (Brazil)', 'Portugus (Brasil)', 22, '1', 1, NULL, 0, 0, 0, 1252, 'pt', NULL, 'BR', 'Pdox ANSI Spanish', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Portuguese (Portugal)', 'portugus (Portugal)', 22, '2', 2, NULL, 0, 0, 0, 1252, 'pt', NULL, 'PT', 'Pdox ANSI Spanish', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Romanian', 'romn', 24, NULL, 1, NULL, 0, 0, 238, 1250, 'ro', NULL, 'RO', 'Pdox ANSI Bulgaria', 'GENERAL_VFP_CI_AS_1250' );
INSERT INTO "AllLanguage" VALUES( 'Russian', '', 25, NULL, 1, NULL, 0, 0, 204, 1251, 'ru', NULL, 'RU', 'Pdox ANSI Cyrillic', 'RUSSIAN_VFP_CI_AS_1251' );
INSERT INTO "AllLanguage" VALUES( 'Serbian', '', 26, NULL, 1, NULL, 0, 0, 204, 1251, 'sr', NULL, 'SP', 'Paradox Czech 852', 'RUSSIAN_VFP_CI_AS_1251' );
INSERT INTO "AllLanguage" VALUES( 'Serbian (Serbia)', 'Serbian ()', 26, '3', 3, NULL, 0, 0, 204, 1251, 'sr', NULL, 'SP', 'Paradox Czech 852', 'RUSSIAN_VFP_CI_AS_1251' );
INSERT INTO "AllLanguage" VALUES( 'Serbian-Latin (Serbia)', 'Serbian-Latin (Srbija)', 26, '2', 2, NULL, 0, 0, 238, 1250, 'sr', NULL, 'SP', 'Borland FRA Latin-1', 'GENERAL_VFP_CI_AS_1250' );
INSERT INTO "AllLanguage" VALUES( 'Slovak', 'slovenina', 27, NULL, 1, NULL, 0, 0, 238, 1250, 'sk', NULL, 'SK', 'Paradox Slovene 852', 'SLOVAK_VFP_CI_AS_1250' );
INSERT INTO "AllLanguage" VALUES( 'Slovenian', 'slovenski', 36, NULL, 1, NULL, 0, 0, 238, 1250, 'sl', NULL, 'SI', 'Paradox Slovene 852', 'SLOVAK_VFP_CI_AS_1250' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Argentina)', 'Espaol (Argentina)', 10, '11', 11, NULL, 0, 0, 0, 1252, 'es', NULL, 'AR', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Bolivia)', 'Espaol (Bolivia)', 10, '16', 16, NULL, 0, 0, 0, 1252, 'es', NULL, 'BO', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Chile)', 'Espaol (Chile)', 10, '13', 13, NULL, 0, 0, 0, 1252, 'es', NULL, 'CL', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Colombia)', 'Espaol (Colombia)', 10, '9', 9, NULL, 0, 0, 0, 1252, 'es', NULL, 'CO', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Costa Rica)', 'Espaol (Costa Rica)', 10, '5', 5, NULL, 0, 0, 0, 1252, 'es', NULL, 'CR', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Dominican Republic)', 'Espaol (Repblica Dominicana)', 10, '7', 7, NULL, 0, 0, 0, 1252, 'es', NULL, 'DO', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Ecuador)', 'Espaol (Ecuador)', 10, '12', 12, NULL, 0, 0, 0, 1252, 'es', NULL, 'EC', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (El Salvador)', 'Espaol (El Salvador)', 10, '17', 17, NULL, 0, 0, 0, 1252, 'es', NULL, 'SV', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Guatemala)', 'Espaol (Guatemala)', 10, '4', 4, NULL, 0, 0, 0, 1252, 'es', NULL, 'GT', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Honduras)', 'Espaol (Honduras)', 10, '18', 18, NULL, 0, 0, 0, 1252, 'es', NULL, 'HN', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Mexico)', 'Espaol (Mxico)', 10, '2', 2, NULL, 0, 0, 0, 1252, 'es', NULL, 'MX', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Nicaragua)', 'Espaol (Nicargua)', 10, '19', 19, NULL, 0, 0, 0, 1252, 'es', NULL, 'NI', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Panama)', 'Espaol (Panam)', 10, '6', 6, NULL, 0, 0, 0, 1252, 'es', NULL, 'PA', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Paraguay)', 'Espaol (Paraguay)', 10, '15', 15, NULL, 0, 0, 0, 1252, 'es', NULL, 'PY', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Peru)', 'Espaol (Per)', 10, '10', 10, NULL, 0, 0, 0, 1252, 'es', NULL, 'PE', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Puerto Rico)', 'Espaol (Puerto Rico)', 10, '20', 20, NULL, 0, 0, 0, 1252, 'es', NULL, 'PR', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Spain)', 'espaol (Espaa)', 10, '1', 1, NULL, 0, 0, 0, 1252, 'es', NULL, 'ES', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Uruguay)', 'Espaol (Uruguay)', 10, '14', 14, NULL, 0, 0, 0, 1252, 'es', NULL, 'UY', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Spanish (Venezuela)', 'Espaol (Venezuela)', 10, '8', 8, NULL, 0, 0, 0, 1252, 'es', NULL, 'VE', 'Pdox ANSI Spanish', 'SPANISH_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Swahili', 'Kiswahili', 65, NULL, 1, NULL, 0, 0, 0, 1252, '??', NULL, '??', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Swedish', 'svenska', 29, NULL, 3, NULL, 0, 0, 0, 1252, 'sv', NULL, 'SE', 'Pdox ANSI Swedfin', 'SWEFIN_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Swedish (Finland)', 'svenska (Finland)', 29, '2', 2, NULL, 0, 0, 0, 1252, 'sv', NULL, 'FI', 'Paradox ''swedfin''', 'SWEFIN_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Swedish (Sweden)', 'svenska (Sverige)', 29, '1', 1, NULL, 0, 0, 0, 1252, 'sv', NULL, 'SE', 'Paradox ''swedfin''', 'SWEFIN_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Tatar', '', 68, NULL, 1, NULL, 0, 0, 204, 1251, '??', NULL, '??', '''ascii'' ANSI', 'RUSSIAN_VFP_CI_AS_1251' );
INSERT INTO "AllLanguage" VALUES( 'Thai', '', 30, NULL, 1, NULL, 0, 0, 222, 874, 'th', NULL, 'TH', 'Paradox Thai 874', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Turkish', 'Trke', 31, NULL, 1, NULL, 0, 0, 162, 1254, 'tr', NULL, 'TR', 'Paradox ''turk''', 'TURKISH_VFP_CI_AS_1254' );
INSERT INTO "AllLanguage" VALUES( 'Ukrainian', '', 34, NULL, 1, NULL, 0, 0, 204, 1251, 'uk', NULL, 'UA', 'Pdox ANSI Cyrillic', 'RUSSIAN_VFP_CI_AS_1251' );
INSERT INTO "AllLanguage" VALUES( 'Urdu', 'Urdu', 32, NULL, 1, NULL, 0, 0, 178, 1256, NULL, NULL, NULL, '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Uzbek, Cyrillic', '', 67, NULL, 1, NULL, 0, 0, 204, 1251, '??', NULL, '??', 'Pdox ANSI Cyrillic', 'RUSSIAN_VFP_CI_AS_1251' );
INSERT INTO "AllLanguage" VALUES( 'Uzbek, Cyrillic (Republic of Uzb', ', Cyrillic ()', 67, '2', 2, NULL, 0, 0, 204, 1251, '??', '??', '??', 'Pdox ANSI Cyrillic', 'RUSSIAN_VFP_CI_AS_1251' );
INSERT INTO "AllLanguage" VALUES( 'Uzbek, Latin', 'U''zbek', 67, NULL, 2, NULL, 0, 0, 162, 1254, '??', NULL, '??', 'Borland FRA Latin-1', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Uzbek, Latin (Republic of Uzbeki', 'U''zbek, Latin (U''zbekiston Respu', 67, '1', 1, NULL, 0, 0, 162, 1254, '??', '??', '??', 'Borland FRA Latin-1', 'GENERAL_VFP_CI_AS_1252' );
INSERT INTO "AllLanguage" VALUES( 'Vietnamese', 'Ting Vit Nam', 42, NULL, 1, NULL, 0, 0, 163, 1258, 'vi', NULL, 'VN', '''ascii'' ANSI', 'GENERAL_VFP_CI_AS_1252' );
